{= Code Fragments Extracted from GRAPHICS.PAS =}

type
  TPicture = class(TPersistent)
    . . .
  public
    class procedure RegisterFileFormat(const AExtension, 
      ADescription: string; AGraphicClass: TGraphicClass);
    . . .
  end;


{= Source Code Deleted =}

type
  PFileFormat = ^TFileFormat;
  TFileFormat = record
    GraphicClass: TGraphicClass;
    Extension: TExtension;
    Description: PString;
    Next: PFileFormat;
  end;

var
  SMetafiles, SIcons, SBitmaps: string[15]; 

{ Pre-registered file formats }
const
  MetafileFormat: TFileFormat = (
    GraphicClass: TMetafile;
    Extension: 'WMF';
    Description: @SMetafiles);
  IconFormat: TFileFormat = (
    GraphicClass: TIcon;
    Extension: 'ICO';
    Description: @SIcons;
    Next: @MetafileFormat);
  BitmapFormat: TFileFormat = (
    GraphicClass: TBitmap;
    Extension: 'BMP';
    Description: @SBitmaps;
    Next: @IconFormat);
  FileFormatList: PFileFormat = @BitmapFormat;


{= Source Code Deleted =}

{ Add AGraphicClass to the list of registered TGraphic classes. }

class procedure TPicture.RegisterFileFormat(const AExtension,
  ADescription : string; AGraphicClass : TGraphicClass);
var
  NewRec : PFileFormat;
begin
  New( NewRec );
  with NewRec^ do
  begin
    Extension := UpperCase(AExtension);
    GraphicClass := AGraphicClass;
    Description := NewStr(ADescription);
    Next := FileFormatList;
  end;
  FileFormatList := NewRec;
end;
