/* Simple Dialog program -- Williams

Borland: bcc -v -WS simsave.c cmdoicon.c
         brc simsave.rc simsave.exe

Microsoft: cl -Zi -GA simple.c cmdoicon.c simple.def commdlg.lib ctl3dv2.lib
           rc simsave.rc simsave.exe */

#include <windows.h>
#include <commdlg.h>
#include <ctl3d.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "simsave.h"
#include "cmdoicon.h"

int save(HWND);

BOOL FAR PASCAL _export dp(HWND dlg,UINT cmd,
  WPARAM wParam,LPARAM lParam)
  {
  if (cmd==WM_COMMAND&&wParam==SAVE)
    {
    int err=save(dlg);
    if (err>0)
      MessageBox(dlg,"File Error!",NULL,MB_OK|MB_ICONSTOP);
    if (err==0)
      EndDialog(dlg,0);
    return TRUE;
    }
  if (cmd==WM_COMMAND&&wParam==IDOK)
    {
    EndDialog(dlg,0);
    return TRUE;
    }
  return FALSE;
  }

int PASCAL WinMain(HANDLE hInst,HANDLE prev,
  LPSTR cmd,int show )
  {
/* Set up CTL3D library */
  Ctl3dRegister(hInst);
  Ctl3dAutoSubclass(hInst);
/* Put icon in place */
  if (!prev) cmdoicon(hInst,"COMMANDO",
    LoadIcon(hInst,MAKEINTRESOURCE(APPICON)));
  DialogBox(hInst,"MAINDLG",NULL,dp);
  Ctl3dUnregister(hInst);
  }

/* Save file */
int save(HWND w)
  {
  OPENFILENAME of;
  FILE *f;
  char fn[_MAX_PATH],line[256];
  unsigned lnct,maxline,len;
  HWND ectl;
/* Set up OPENFILENAME */
  *fn='\0';
  memset(&of,0,sizeof(of));
  of.lStructSize=sizeof(of);
  of.hwndOwner=w;
  of.hInstance=GetWindowWord(w,GWW_HINSTANCE);
  of.lpstrFile=fn;
  of.nMaxFile=sizeof(fn);
  of.Flags=OFN_OVERWRITEPROMPT|
    OFN_PATHMUSTEXIST|OFN_HIDEREADONLY;
/* Call common dialog */
  if (!GetSaveFileName(&of))
    {
    if (CommDlgExtendedError())
      return 1;
    return -1;
    }
  ectl=GetDlgItem(w,EDIT_CONTROL);
/* Get # of text lines */
  maxline=SendMessage(ectl,EM_GETLINECOUNT,0,0);
/* Write it out */
  f=fopen(fn,"w");
  if (!f)
    return 1;
  for (lnct=0;lnct<maxline;lnct++)
    {
    *(WORD *)line=sizeof(line)-2;
    len=SendMessage(ectl,EM_GETLINE,lnct,(DWORD)line);
    line[len]='\n';
    line[len+1]='\0';
    fputs(line,f);
    }
  if (fclose(f)) return 1;
  return 0;
  }
