/********************************************
 *                                          *
 * ATASKMAN -- task manager replacment      *
 * Williams                                 *
 *                                          *
 ********************************************/
#include <windows.h>
#include <stdlib.h>
#include <mmsystem.h>
#include <commdlg.h>
#include <toolhelp.h>
#include <string.h>
#include "ataskman.h"
#include "cmdoicon.h"
/* Set to 1 for 3-d look */
#define USETHREEDDLG 1
#if USETHREEDDLG
#include <ctl3d.h>
#endif

/* Various globals */
HANDLE hInst;
HWND dialog;         // main window
/* Options */
struct _opt
  {
  int hidden;      // display hidden?
  int quitter;     // quit after op?
  char *soundfile; // play sound name
  } opt;

/* Globals for window search */
int enum_mode=0;  // found?
char buf[66];     // window name
HWND buf_w;       // window handle

/* Undocumented taskmanager calls */
extern void FAR PASCAL CascadeChildWindows(HWND,int);
extern void FAR PASCAL TileChildWindows(HWND,int);
extern void FAR PASCAL SwitchToThisWindow(HWND,BOOL);

/* Enumeration function for task windows */
BOOL FAR PASCAL winfunc(HWND w,DWORD lParam)
   {
   char lbuf[66];
   int n;
   if (w==dialog) return TRUE;  // ignore ourself
/* If window has parent, skip it */
   if (GetParent(w)) return TRUE;
/* If only viewing visible, skip invisible */
   if (!opt.hidden&&!IsWindowVisible(w)) return TRUE;
/* Get window title */
   SendMessage(w,WM_GETTEXT,sizeof(lbuf),(DWORD)lbuf);
   if (!*lbuf) return TRUE;  // no title, skip
/* If current window is invisible or popup, don't
   override existing selected popup/invisible
   window */
   if (enum_mode==1&&
       ((GetWindowLong(w,GWL_STYLE)&WS_POPUP)||
        !IsWindowVisible(w)))
          return TRUE;
/* set window info */
   strcpy(buf,lbuf);
   buf_w=w;
   enum_mode=1;
/* Try to find a visible, non-popup if possible */
   if (!IsWindowVisible(w)) return TRUE;
   if (GetWindowLong(w,GWL_STYLE)&WS_POPUP) return TRUE;
/* Visible window, we're done! */
   return FALSE;
   }

/* Set up list box */
void setup(HWND lb)
  {
  TASKENTRY tsk;
  int more=GetNumTasks()-1;  // get # of tasks
/* Clear list box */
  SendMessage(lb,LB_RESETCONTENT,0,0);
  tsk.dwSize=sizeof(tsk);
  if (!TaskFirst(&tsk)) return;
  do // for each task
    {
    enum_mode=0;
    EnumTaskWindows(tsk.hTask,winfunc,(DWORD)lb);
    if (enum_mode)
      {
      int n;
      // add to list box
      n=SendMessage(lb,LB_ADDSTRING,0,(DWORD)buf);
      SendMessage(lb,LB_SETITEMDATA,n,buf_w);
      }
    TaskNext(&tsk);
    } while (--more);  // do next task
  }


/* Set up display options */
void set_opts(HWND hDlg)
  {
  SendDlgItemMessage(hDlg,INVISIBLE,BM_SETCHECK,opt.hidden,0);
  SendDlgItemMessage(hDlg,VISIBLE,BM_SETCHECK,!opt.hidden,0);
  }


/* main dialog function */
int FAR PASCAL dlgfunc(HWND hDlg, WORD wMsg,
                       WORD wParam, DWORD lParam)
   {
   static HWND lb;
   int n;
   HMENU m;
   switch (wMsg)
      {
      case WM_INITDIALOG:
        dialog=hDlg;
/* Change system menu */
        m=GetSystemMenu(hDlg,FALSE);
        AppendMenu(m,MF_SEPARATOR,0,NULL);
        AppendMenu(m,MF_STRING,0x100,"About ATASKMAN...");
        AppendMenu(m,MF_STRING,0x110,"Options...");
/* Do set up */
        setup(lb=GetDlgItem(hDlg,TASK_LIST));
/* Set radio buttons */
        set_opts(hDlg);
        return 0;

      case WM_SYSCOMMAND:
         if ((wParam&0xFFF0)==0x100) // about
           {
           MessageBox(hDlg,"ATASKMAN 1.0\n"
             "(C) 1993 by Al Williams","About",
             MB_OK|MB_ICONINFORMATION);
           return 1;
           }
         if ((wParam&0xFFF0)==0x110)  // set options
           {
           /* Do option dialog */
           popup_optdlg(hDlg);
           set_opts(hDlg);
           setup(lb);
           }
         return 0;

      case WM_CLOSE:
         EndDialog(hDlg,TRUE);
         return TRUE;

      case WM_COMMAND:
        switch (wParam)
          {
          HWND w=NULL;

          case TASK_LIST:
            if (HIWORD(lParam)!=LBN_DBLCLK)
              return TRUE;
/* Fall into switch to case for dbl click */
          case SWITCH_TO:
            n=SendMessage(lb,LB_GETCURSEL,0,0);
            if (n==LB_ERR) return TRUE;
            w=SendMessage(lb,LB_GETITEMDATA,n,0);
            if (w)
              {
              SwitchToThisWindow(w,TRUE);
              if (opt.quitter) goto done;
              }
            return TRUE;

          case IDCANCEL:
done:
            EndDialog(hDlg,TRUE);
            return TRUE;

          case TASK_END:  // send WM_CLOSE
            n=SendMessage(lb,LB_GETCURSEL,0,0);
            if (n==LB_ERR) return TRUE;
            w=SendMessage(lb,LB_GETITEMDATA,n,0);
            if (w)
              {
              SendMessage(w,WM_CLOSE,0,0);
              if (opt.quitter) goto done;
              setup(lb);
              }
            return TRUE;

          case CASCADE:
            CascadeChildWindows(GetDesktopWindow(),0);
            if (opt.quitter) goto done;
            return TRUE;

          case TILE:
            TileChildWindows(GetDesktopWindow(),0);
            if (opt.quitter) goto done;
            return TRUE;

          case ARRANGE:
            ArrangeIconicWindows(GetDesktopWindow());
            if (opt.quitter) goto done;
            return TRUE;

          case ENDWIN:
            if (MessageBox(hDlg,
               "This will end your Windows session.\n"
               "OK to continue?","Notice",
                MB_YESNO|MB_DEFBUTTON2|
                MB_ICONEXCLAMATION)!=IDYES)
                  return TRUE;
            ExitWindows(0,0);
            return TRUE;

          case TERMINATE:
            n=SendMessage(lb,LB_GETCURSEL,0,0);
            if (n==LB_ERR) return TRUE;
              w=SendMessage(lb,LB_GETITEMDATA,n,0);
            if (!w) return TRUE;
            if (MessageBox(hDlg,
               "Warning! Ending terminating an application"
               " may cause lost system resources.\n"
               "OK to terminate?","WARNING",
               MB_YESNO|MB_ICONEXCLAMATION|
               MB_DEFBUTTON2)==IDNO)
                 return TRUE;
            TerminateApp(GetWindowTask(w),NO_UAE_BOX);
            if (opt.quitter) goto done;
            setup(lb);
            return TRUE;

          case WINDOW:
            n=SendMessage(lb,LB_GETCURSEL,0,0);
            if (n==LB_ERR) return TRUE;
            w=SendMessage(lb,LB_GETITEMDATA,n,0);
            if (!w) return TRUE;
            popup_windlg(hDlg,w);
            setup(lb);  // refresh
            return TRUE;

          case VISIBLE:
            opt.hidden=0;
            setup(lb);
            return TRUE;

          case INVISIBLE:
            opt.hidden=1;
            setup(lb);
          default:
             return 0;
          }
      }
   return 0;
   }


/* Show states */
int showary[]=
  {
  SW_RESTORE,
  SW_HIDE,
  SW_MINIMIZE,
  SW_MAXIMIZE
  };

/* Window options */
BOOL CALLBACK wind_proc(HWND hDlg,UINT cmd,WPARAM wParam,
  LPARAM lParam)
  {
  char buf[129];
  static HWND w;
  switch (cmd)
    {
    case WM_INITDIALOG:
        w=(HWND)lParam;  // window to process
        SendMessage(w,WM_GETTEXT,sizeof(buf),(DWORD)buf);
        SendDlgItemMessage(hDlg,WINNAME,WM_SETTEXT,0,
          (DWORD)buf);  // get title
        SendDlgItemMessage(hDlg,WINCAP,WM_SETTEXT,0,
          (DWORD)buf);
        SendDlgItemMessage(hDlg,WINCAP,EM_SETSEL,1,
          MAKELONG(0xFFFF,0));
        SendDlgItemMessage(hDlg,WINSAME,BM_SETCHECK,
          TRUE,0);
/* Set/clear topmost bit */
        SendDlgItemMessage(hDlg,TOPMOST,BM_SETCHECK,
          (WPARAM)(GetWindowLong(w,
            GWL_EXSTYLE)&WS_EX_TOPMOST),0L);
        return TRUE;

    case WM_COMMAND:
       switch (wParam)
         {
         int i;
         case IDOK:
/* Set caption */
         SendDlgItemMessage(hDlg,WINCAP,WM_GETTEXT,
           sizeof(buf),(DWORD)buf);
         SendMessage(w,WM_SETTEXT,0,(DWORD)buf);
/* process radio buttons */
         for (i=WINSHOW;i<WINSAME;i++)
           if (SendDlgItemMessage(hDlg,i,BM_GETCHECK,0,0))
             {
             ShowWindow(w,showary[i-WINSHOW]);
             break;
             }
/* Set/clear topmost status */
          if (SendDlgItemMessage(hDlg,TOPMOST,BM_GETCHECK,0,0))
            SetWindowPos(w,HWND_TOPMOST,0,0,0,0,
              SWP_NOMOVE|SWP_NOSIZE);
          else
            SetWindowPos(w,HWND_NOTOPMOST,0,0,0,0,
              SWP_NOMOVE|SWP_NOSIZE);
/* fall into cancel case */
          case IDCANCEL:
          EndDialog(hDlg,wParam);
          return TRUE;
          }
    }
  return FALSE;
  }


/* Show window dialog */
void popup_windlg(HWND w,HWND target)
  {
  DialogBoxParam(hInst,MAKEINTRESOURCE(WINDLG),
     w,wind_proc,(DWORD)target);
  }

/* Generic implemntation of file browse button
  parent=your window or dialog
  w=edit control inside parent to get name
  title=file open dialog title
  filter=file open dialog filter (see COMMDLG docs) */
int browse_file(HWND parent,HWND w ,char *title,char *filter)
  {
  OPENFILENAME of;
  char fn[_MAX_PATH],ft[_MAX_PATH],dir[_MAX_PATH],*p;
  SendMessage(w,WM_GETTEXT,_MAX_PATH,(DWORD)fn);
  strcpy(dir,fn);
  p=strrchr(dir,'\\');
  if (p) *p='\0'; else *dir='\0';
  memset(&of,0,sizeof(of));
  of.lStructSize=sizeof(of);
  of.hwndOwner=parent;
  of.hInstance=hInst;
  of.lpstrFilter=filter;
  of.nFilterIndex=1;
  of.lpstrFile=fn;
  of.lpstrFileTitle=ft;
  of.nMaxFile=of.nMaxFileTitle=_MAX_PATH;
  of.lpstrTitle=title;
  of.lpstrInitialDir=dir;
  of.Flags=OFN_FILEMUSTEXIST|OFN_HIDEREADONLY;
  if (!GetOpenFileName(&of)) return 1;
  SendMessage(w,WM_SETTEXT,0,(DWORD)fn);
  return 0;
  }

/* Process options */
BOOL CALLBACK opt_proc(HWND hDlg,UINT cmd,WPARAM wParam,
  LPARAM lParam)
  {
  char buf[33];
  switch (cmd)
    {
    case WM_INITDIALOG:
      {
      int hideem=GetPrivateProfileInt("Preferences","showhidden",0,"ATASKMAN.INI");
      SendDlgItemMessage(hDlg,OPTSHOW,BM_SETCHECK,hideem,0);
      SendDlgItemMessage(hDlg,OPTQUIT,BM_SETCHECK,opt.quitter,0);
      SendDlgItemMessage(hDlg,SOUNDFILE,WM_SETTEXT,0,
        (DWORD)opt.soundfile);
      SendDlgItemMessage(hDlg,SOUNDFILE,EM_SETSEL,0,
        MAKELONG(0,0xFFFF));
      return TRUE;
      }

   case WM_COMMAND:
     switch (wParam)
       {
       HWND tmpw;
       case BROWSE:
         browse_file(hDlg,tmpw=GetDlgItem(hDlg,SOUNDFILE),
           "Select WAVE file",
           "Wave files (*.wav)\0*.wav\0"
           "All files (*.*)\0*.*\0");
         SendMessage(tmpw,EM_SETSEL,0,MAKELONG(0,0xFFFF));
         SetFocus(tmpw);
         break;

       case TEST:
         {
         char tmp[_MAX_PATH];
         tmpw=GetDlgItem(hDlg,SOUNDFILE);
         SendMessage(tmpw,WM_GETTEXT,_MAX_PATH,(DWORD)tmp);
         if (*tmp) sndPlaySound(tmp,
           SND_SYNC|SND_NODEFAULT);
         SendMessage(tmpw,EM_SETSEL,0,MAKELONG(0,0xFFFF));
         SetFocus(tmpw);
         }
       break;

       case IDOK:
         opt.hidden=SendDlgItemMessage(hDlg,OPTSHOW,
           BM_GETCHECK,0,0);
         opt.quitter=SendDlgItemMessage(hDlg,OPTQUIT,
           BM_GETCHECK,0,0);
         wsprintf(buf,"%d",opt.hidden);
         WritePrivateProfileString("Preferences",
           "showhidden",buf,"ATASKMAN.INI");
         wsprintf(buf,"%d",opt.quitter);
         WritePrivateProfileString("Preferences",
           "quit",buf,"ATASKMAN.INI");
         SendDlgItemMessage(hDlg,SOUNDFILE,WM_GETTEXT,
           _MAX_PATH,(DWORD)opt.soundfile);
         WritePrivateProfileString("Preferences","sound",
           opt.soundfile,"ATASKMAN.INI");

         case IDCANCEL:
           EndDialog(hDlg,wParam);
           return TRUE;
         }
    }
  return FALSE;
  }

/* Option dialog */
void popup_optdlg(HWND w)
  {
  DialogBox(hInst,MAKEINTRESOURCE(OPTDLG),w,opt_proc);
  }


/* Main window function */
int PASCAL WinMain(HANDLE hInstance, HANDLE prev,
    LPSTR cmdline, int show)
   {
   static char sound[_MAX_PATH];
   hInst=hInstance;
   opt.hidden=GetPrivateProfileInt("Preferences",
     "showhidden",0,"ATASKMAN.INI");
   opt.quitter=GetPrivateProfileInt("Preferences",
     "quit",0,"ATASKMAN.INI");
   GetPrivateProfileString("Preferences","sound","",sound,
     sizeof(sound),"ATASKMAN.INI");
#if USETHREEDDLG
   Ctl3dRegister(hInst);
   Ctl3dAutoSubclass(hInst);
#endif
  if (*sound)
     sndPlaySound(sound,SND_ASYNC|SND_NOSTOP|SND_NODEFAULT);
   opt.soundfile=sound;
   if (!prev)
     cmdoicon(hInst,"CMDODLG",LoadIcon(hInst,"APPICO"));
   DialogBox(hInst,"TASKDLG",NULL,dlgfunc);

#if USETHREEDDLG
   Ctl3dUnregister(hInst);
#endif
  return FALSE;
  }
