/***********************************
 * LZWAV.C  by  Al Williams        *
 *                                 *
 * Prompt for input using          *
 * compressed wave files.          *
 *                                 *
 * Compile with small model and    *
 * smart callbacks.                *
 * Borland:                        *
 *    bcc -v -WS lzwav.c           *
 *    brc lzwav.rc lzwav.exe       *
 *                                 *
 * Microsoft:                      *
 *    cl -Zi -GA lzwav.c           *
 *    rc lzwav.rc lzwav.exe        *
 *                                 *
 ***********************************/
#include <windows.h>
#include <stdio.h>
#include <lzexpand.h>
#include <mmsystem.h>
#include "lzwav.h"



/* current instance */
HANDLE hInst;
/* Data entry dialog handle */
HWND dlg;

/* Main window function */
int PASCAL  WinMain(HANDLE hInst, HANDLE prev,
                   LPSTR cmdline, int show)
    {
    MSG msg;
    if (init(hInst,prev,show))
    /* Vanilla event loop */
      while (GetMessage(&msg,NULL,NULL,NULL))
          {
          TranslateMessage(&msg);
          DispatchMessage(&msg);
          }
    return (msg.wParam);
    }

/* Start up stuff */
int init(HANDLE hInst, HANDLE prev,int show)
   {
   if (!prev)
      if (!init_app(hInst))
/* Exit if unable to init */
         return FALSE;
/* Perform instance init */
   return init_inst(hInst,show);
   }

/* Create window class here */
BOOL init_app(HANDLE hInstance)
    {
    WNDCLASS  wc;
/* Set up ordinary window class */
    wc.style=0;
    wc.lpfnWndProc=(void FAR *)win_proc;
    wc.cbClsExtra=0;
    wc.cbWndExtra=0;
    wc.hInstance=hInstance;
    wc.hIcon=LoadIcon(NULL, IDI_APPLICATION);
    wc.hCursor=LoadCursor(NULL, IDC_ARROW);
    wc.hbrBackground=GetStockObject(WHITE_BRUSH);
    wc.lpszMenuName= "LZWAVMENU";
    wc.lpszClassName="LZWAVClass";
    return (RegisterClass(&wc));
    }



/* Create window here */
BOOL init_inst(HANDLE hInstance, int nCmdShow)
    {
    HWND            hWnd;
    /* Save the instance handle in global variable */
    hInst=hInstance;
    /* Create a main window */
    hWnd=CreateWindow(
        "LZWAVClass","LZWAVE Demo",
        WS_OVERLAPPEDWINDOW,CW_USEDEFAULT,
        CW_USEDEFAULT,CW_USEDEFAULT,
        CW_USEDEFAULT,NULL,
        NULL,hInstance,NULL);
    if (!hWnd)
        return FALSE;

/* Make the window visible, update its client area,
     and return "success" */
    ShowWindow(hWnd, nCmdShow);
    UpdateWindow(hWnd);
    RCsndPlaySound("WELCOME");
    return TRUE;
    }


/* Dialog procedure */
BOOL WINAPI _export dlgproc(HWND hdlg,UINT message,
  UINT wParam,LONG lParam)
  {
  switch (message)
    {
    case WM_INITDIALOG:
       dlg=hdlg;      /* set global */
       return TRUE;

    case WM_COMMAND:
       switch (wParam)
         {
         case IDOK:
           writedata(hdlg);
/* Clear fields and set cursor */
           SendDlgItemMessage(hdlg,NAME,
              WM_SETTEXT,0,(DWORD)"");
           SendDlgItemMessage(hdlg,TELNO,
              WM_SETTEXT,0,(DWORD)"");
           SetFocus(GetDlgItem(hdlg,NAME));
           return TRUE;

         case IDCANCEL:
           EndDialog(hdlg,TRUE);
           dlg=NULL;
           return TRUE;
         }
    }
  return FALSE;
  }


/* Write data to data file */
BOOL writedata(HWND w)
  {
  FILE *f=fopen("data","a");
  char datastring[256];
  if (!f) return FALSE;
  GetDlgItemText(w,NAME,datastring,sizeof(datastring));
  fprintf(f,"%s\t",datastring);
  GetDlgItemText(w,TELNO,datastring,sizeof(datastring));
  fprintf(f,"%s\n",datastring);
  if (fclose(f)) return FALSE;
  return TRUE;
  }

/* Prompt with sound if code==MSGF_MENU then dlgw is a
   menu id. if code!+MSGF_MENU then dlgw is a child
   window id.       */
void prompt(UINT code,UINT dlgw)
  {
  static char snd[66];
  static UINT last=-1;
  if (last!=dlgw&&LoadString(hInst,dlgw,snd,sizeof(snd)))
     {
     last=dlgw;
     LZsndPlaySound(snd,SND_ASYNC|SND_NODEFAULT);
     }
  }

/* Window procedure */
long WINAPI _export win_proc(HWND hWnd, UINT message,
                            UINT wParam, LONG lParam)
    {
    HWND edctl;
    switch (message)
        {
        case WM_ENTERIDLE:
           {
/* Check for modal dialog box control in focus */
           HWND w=GetFocus();
           if (wParam==MSGF_DIALOGBOX&&w
               &&dlg&&dlg==GetParent(w))
             prompt(wParam,GetWindowWord(w,GWW_ID));
           }
           break;

        case WM_MENUSELECT:
/* If enabled, valid, non-system menu, prompt */
            if (LOWORD(lParam)!=MF_DISABLED&&
                LOWORD(lParam)!=MF_SEPARATOR&&
                LOWORD(lParam)!=MF_SYSMENU)
                  prompt(MSGF_MENU,wParam);
            break;

        case WM_COMMAND:
            menu(hWnd,wParam);
            break;

        case WM_DESTROY:
/* Be sure to turn off sound before memory becomes invalid */
             sndPlaySound(NULL,NULL);
             PostQuitMessage(0);
             break;

        default:
            return (DefWindowProc(hWnd, message,
                    wParam, lParam));
        }
    return NULL;
    }


/* Handle menu commands */
void menu(HWND hWnd,UINT wParam)
  {
  switch (wParam)
    {
    case MENU_NEW:
      unlink("data");     /* Erase data file */
      break;

    case MENU_ABOUT:
      MessageBox(hWnd,"LZWAV by Al Williams","About",
        MB_OK|MB_ICONEXCLAMATION);
      break;

    case MENU_EXIT:
      DestroyWindow(hWnd);
      break;

    case MENU_ENTER:
/* Bring up dialog (assume smart callbacks) */
      DialogBox(hInst,"INPUTBOX",hWnd,dlgproc);
      break;
    }
  }

/* Play compressed or uncompressed sound file 100,000 bytes
   or less */
BOOL LZsndPlaySound(LPCSTR fn,DWORD flg)
  {
/* Must be static! Windows will read from this array after
   the function returns */
  static huge char soundbytes[100000];
  HFILE sf;
  OFSTRUCT ofs;
  int i;
  sf=LZOpenFile(fn,&ofs,OF_READ);
  if (sf==-1) return FALSE;
  for (i=0;i<4;i++)
     LZRead(sf,soundbytes+i*32767L,
            (int)min(32767L,
            sizeof(soundbytes)-i*32767L));
  LZClose(sf);
  sndPlaySound(soundbytes,flg|SND_MEMORY);
  return TRUE;
  }

/* Play sound file from resource */
BOOL RCsndPlaySound(LPCSTR s)
  {
  HANDLE info, wave;
  LPSTR lpwave;
  BOOL rv=TRUE;
  /* Find the WAVE resource */
  info = FindResource(hInst, s, "WAVE");
  if (!info) return FALSE;
  wave = LoadResource(hInst, info);  // Load it
  if (!wave) return FALSE;
  lpwave = LockResource(wave);    // Lock it
  if (lpwave)
    {
    sndPlaySound(lpwave,
      SND_MEMORY | SND_SYNC | SND_NODEFAULT);
    UnlockResource(wave);  // Unlock
    }
  else
    rv=FALSE;
/* Free the WAVE resource */
  FreeResource(wave);
  return rv;
  }
