// hexocx.odl : type library source for OLE Custom Control project.

// This file will be processed by the Make Type Library (mktyplib)
// tool to produce the type library (hexocx.tlb) that will become
// a resource in hexocx.ocx.

#include <olectl.h>

[ uuid(37D341A8-6B82-101B-A4E3-08002B291EED), version(1.0),
  helpstring("Hexocx OLE Custom Control module") ]
library Hexocx
{
  importlib(STDOLE_TLB);
  importlib(STDTYPE_TLB);
  
  //  Primary dispatch interface for CHexocxCtrl
  
  [ uuid(37D341A6-6B82-101B-A4E3-08002B291EED),
    helpstring("Dispatch interface for Hexocx Control") ]
  dispinterface _DHexocx
  {
    properties:
      // NOTE - ClassWizard will maintain property information here
      //    Use extreme caution when editing this section.
      //{{AFX_ODL_PROP(CHexocxCtrl)
      [id(13)] long FileLength;
      [id(1)] boolean FireUndoEvents;
      [id(2)] BSTR SearchString;
      [id(3)] boolean SearchCaseFlag;
      [id(4)] boolean SearchFromStart;
      [id(5)] boolean SearchDropFlag;
      [id(6)] boolean Wrap;
      [id(7)] boolean InAscii;
      [id(8)] boolean OnHighNibble;
      [id(9)] BSTR DefaultChar;
      [id(10)] boolean MaskTopBit;
      [id(11)] boolean ShowAllChars;
      [id(12)] short LinesToScroll;
      [id(14)] boolean ReadOnly;
      [id(15)] short CurrentByte;
      [id(16)] long Offset;
      [id(17)] boolean Dirty;
      [id(18)] short Alignment;
      [id(19)] short Bookmarks;
      [id(20)] BSTR SearchSequence;
      [id(21)] BSTR Filename;
      [id(DISPID_FONT), bindable] IFontDisp* Font;
      //}}AFX_ODL_PROP
      
    methods:
      // NOTE - ClassWizard will maintain method information here.
      //    Use extreme caution when editing this section.
      //{{AFX_ODL_METHOD(CHexocxCtrl)
      [id(38), propget] long Bookmark(short nIndex);
      [id(38), propput] void Bookmark(short nIndex,long nNewValue);
      [id(22)] boolean Save();
      [id(23)] boolean SaveAs(BSTR Filename);
      [id(24)] boolean Undo();
      [id(25)] boolean UndoAll();
      [id(26)] void FileClose();
      [id(27)] short Search(boolean bIsString);
      [id(28)] short SearchAgain();
      [id(29)] void ClearAllBookmarks();
      [id(30)] boolean DropBookmark();
      [id(31)] boolean ClearBookmark();
      [id(32)] void GotoNextBookmark();
      [id(33)] void GotoPreviousBookmark();
      [id(34)] void GotoBookmark(short nIndex);
      [id(35)] void GotoStartOfFile();
      [id(36)] void GotoEndOfFile();
      [id(37)] boolean FileOpen(BSTR Filename);
      //}}AFX_ODL_METHOD

      [id(DISPID_ABOUTBOX)] void AboutBox();
  };

  //  Event dispatch interface for CHexocxCtrl
  
  [ uuid(37D341A7-6B82-101B-A4E3-08002B291EED),
    helpstring("Event interface for Hexocx Control") ]
  dispinterface _DHexocxEvents
  {
    properties:
      //  Event interface has no properties
      
    methods:
      // NOTE - ClassWizard will maintain event information here.
      //    Use extreme caution when editing this section.
      //{{AFX_ODL_EVENT(CHexocxCtrl)
      [id(1)] void ByteChanged(long Position, short OldValue,
      short NewValue);
      //}}AFX_ODL_EVENT
  };

  //  Class information for CHexocxCtrl
  
  [ uuid(37D341A5-6B82-101B-A4E3-08002B291EED),
    helpstring("Hexocx Control") ]
  coclass Hexocx
  {
    [default] dispinterface _DHexocx;
    [default, source] dispinterface _DHexocxEvents;
  };

};
