BEGIN_DISPATCH_MAP(CHexocxCtrl, COleControl)
  //{{AFX_DISPATCH_MAP(CHexocxCtrl)
  DISP_PROPERTY(CHexocxCtrl, "FireUndoEvents", m_bFireUndoEvents, \
  VT_BOOL)
    // some entries removed
  DISP_PROPERTY_NOTIFY(CHexocxCtrl, "InAscii", m_bInAscii, \
  HexAsciiSwitch, VT_BOOL)
    // some entries removed
  DISP_PROPERTY_EX(CHexocxCtrl, "FileLength", GetFileLength, \
  SetNotSupported, VT_I4)
    // some entries removed
  DISP_FUNCTION(CHexocxCtrl, "Save", Save, VT_BOOL, VTS_NONE)
    // some entries removed
  DISP_PROPERTY_PARAM(CHexocxCtrl, "Bookmark", GetBookmark, \
  SetBookmark, VT_I4, VTS_I2)
  DISP_DEFVALUE(CHexocxCtrl, "CurrentByte")
  DISP_STOCKPROP_FONT()
  //}}AFX_DISPATCH_MAP
  DISP_FUNCTION_ID(CHexocxCtrl, "AboutBox", DISPID_ABOUTBOX, \
  AboutBox, VT_EMPTY, VTS_NONE)
END_DISPATCH_MAP()

BEGIN_EVENT_MAP(CHexocxCtrl, COleControl)
  //{{AFX_EVENT_MAP(CHexocxCtrl)
  EVENT_CUSTOM("ByteChanged", FireByteChanged, VTS_I4  VTS_I2  \
  VTS_I2)
  //}}AFX_EVENT_MAP
END_EVENT_MAP()

void CHexocxCtrl::OnKillFocus(CWnd* pNewWnd) 
{
  COleControl::OnKillFocus(pNewWnd);

    // hide the caret as appropriate
  if ( m_bGotCaret )
  {
    HideCaret ( );
    ::DestroyCaret ( );
    m_bGotCaret = FALSE;
  }
}

void CHexocxCtrl::OnSetFocus(CWnd* pOldWnd) 
{
  COleControl::OnSetFocus(pOldWnd);
  
    // no caret if there's no file open
  if ( CheckFile ( FALSE ) == FALSE )
  {
    m_bGotCaret = FALSE;
    return;
  }
  
  if ( m_bGotCaret == FALSE )
  {
    CreateSolidCaret ( m_nCaretWidth, m_nCaretHeight );
    ShowCaret ( );
    MoveCursor ( );
    m_bGotCaret = TRUE;
  }
}

BOOL CHexocxCtrl::OnTranslateAccelerator ( LPMSG lpMsg )
{
  switch ( lpMsg -> message )
  {
    case WM_KEYDOWN:
    case WM_KEYUP:
      switch (lpMsg->wParam)
      {
        case VK_UP:
        case VK_DOWN:
        case VK_LEFT:
        case VK_RIGHT:
        case VK_HOME:
        case VK_END:
        case VK_PRIOR:
        case VK_NEXT:
          SendMessage(lpMsg->message,lpMsg->wParam,lpMsg->lParam);
          return TRUE;
      }
    break;
  }
  return FALSE;
}

long CHexocxCtrl::GetOffset() 
{
  return long ( m_dwOffset + m_iCursor );
}

void CHexocxCtrl::SetOffset(long nNewValue) 
{
  if ( nNewValue >= GetFileLength ( ) )
  {
    ThrowError ( CTL_E_INVALIDPROPERTYVALUE, IDS_HOE_OFFSET );
  }
  MoveToPos ( nNewValue );
}

void CHexocxCtrl::OnMaskTopBitChanged() 
{
  InvalidateControl ( );
}

void CHexocxCtrl::DoPropExchange(CPropExchange* pPX)
{
  ExchangeVersion(pPX, MAKELONG(_wVerMinor, _wVerMajor));
  COleControl::DoPropExchange(pPX);

    // persistent properties
  PX_Short ( pPX, "Alignment", m_nAlignment, 16 );
  PX_Bool ( pPX, "SearchCaseFlag", m_bSearchCaseFlag, FALSE );
  PX_Bool ( pPX, "SearchDropFlag", m_bSearchDropFlag, FALSE );
  PX_Bool ( pPX, "SearchFromStart", m_bSearchFromStart, FALSE );
  PX_String ( pPX, "SearchString", m_csSearchString, "" );
  PX_String ( pPX, "SearchSequence", m_csSearchByteSequence, "" );
  PX_String ( pPX, "DefaultChar", m_cShowAs, "." );
  PX_Bool ( pPX, "MaskTopBit", m_bMask, TRUE );
  PX_Bool ( pPX, "ShowAllChars", m_bShow, FALSE );
  PX_Short ( pPX, "LinesToScroll", m_nLinesToScroll, 1 );
  m_nL2ScollSaved = m_nLinesToScroll;
  PX_Bool ( pPX, "Wrap", m_bWrap, FALSE );
}
