{ ====== Demonstrates how object methods can be chained ====== }
program SelfPoly;
uses Graph;

type
  PPoly = ^TPoly;
  TPoly = object
    Pts: array[0..9] of PointType;
    Count: Integer;
    constructor Init;
    function AddPt(X, Y: Integer): PPoly;   { Result is a PPoly }
    procedure Draw;
  end;

constructor TPoly.Init;
begin
  Count := 0;
end;

function TPoly.AddPt(X, Y: Integer): PPoly;
begin
  Pts[Count].X := X;  Pts[Count].Y := Y;
  Count := Count + 1;
  AddPt := @Self;        { Returns a pointer to the object here }
end;

procedure TPoly.Draw;
begin
  DrawPoly(Count, Pts);
end;

const
  GDriver: Integer = Detect;
  GMode  : Integer = 0;
  Poly: PPoly = nil;

begin
  InitGraph(GDriver, GMode, '\bp\bgi');
  New(Poly, Init);

  { ----- A chain of method calls allows one statement   -----
    ----- to add four points to the polygon AND DRAW IT. ----- }
  Poly^.AddPt(0,0)^.AddPt(99,99)^.AddPt(9,70)^.AddPt(0,0)^.Draw;

  Dispose(Poly);
  CloseGraph;
end.