unit Mainform;

interface

uses WinTypes, WinProcs, Classes, Graphics, Forms, Controls, Apps,
     MsgDlg, Excepts;

type
  TMainWnd = class(TForm)
    GroupBox1: TGroupBox;
    AverageBtn: TButton;
    SumEdt: TEdit;
    NumItemsEdt: TEdit;
    Label1: TLabel;
    Label2: TLabel;
    AverageEdt: TEdit;
    GroupBox2: TGroupBox;
    NoProtBtn: TButton;
    GroupBox3: TGroupBox;
    MinProtBtn: TButton;
    CompProtBtn: TButton;
    Panel1: TPanel;
    ClickHereLbl: TLabel;
    procedure AverageBtnClick(Sender: TObject);
    procedure NoProtBtnClick(Sender: TObject);
    procedure ClickHereLblClick(Sender: TObject);
    procedure MinProtBtnClick(Sender: TObject);
    procedure CompProtBtnClick(Sender: TObject);
    procedure ClickHereLblMouseDown( Sender: TObject;
                                     Button: TMouseButton;
                                     Shift: TShiftState;
                                     X, Y: Integer);
  private
    { Private declarations }
    MousePt : TPoint;
    procedure HitTest;
  public
    { Public declarations }
  end;

  EMouseClickError = class( EMessage );

var
  MainWnd: TMainWnd;

implementation

{$R *.FRM}


procedure TMainWnd.NoProtBtnClick(Sender: TObject);
var
  Num       : Integer;
  NumStr    : string;
  WastedPtr : Pointer;
begin
  GetMem( WastedPtr, 1024 );             { Allocate some memory }
  NumStr := '23b';                     { Invalid Integer String }
               { StrToInt will raise an EConvertError exception }
  Num := StrToInt( NumStr );

                     { Since nothing handles the exception, the }
                 {  following two statements never get executed }
  MessageDlg( 'About to Free Memory', mtInformation, [mbOk], 0 );
  FreeMem( WastedPtr, 1024 );
end;


procedure TMainWnd.MinProtBtnClick(Sender: TObject);
var
  Num       : Integer;
  NumStr    : string;
  WastedPtr : Pointer;
begin
  GetMem( WastedPtr, 1024 );             { Allocate some memory }
  NumStr := '23b';                     { Invalid Integer String }

        { StrToInt will still raise an EConvertError exception. }
    { But this time, since it is part of a try...finally block, }
                   { the memory allocated above can be released }
  try
    Num := StrToInt( NumStr );
  finally
    MessageDlg( 'About to Free Memory', mtInformation, [mbOk], 0 );
    FreeMem( WastedPtr, 1024 );
  end;
    { Note that after the 'About to Free Memory' message box is }
      { displayed, the 'Invalid Integer...' message box appears }
end;


{= In this final version of the resource protection example,   =}
{= we take things to the completion by adding an exception     =}
{= handler to handle the EConvertError exception such that the =}
{= 'Invalid Integer...' error message is no longer displayed.  =}

procedure TMainWnd.CompProtBtnClick(Sender: TObject);
var
  Num       : Integer;
  NumStr    : string;
  WastedPtr : Pointer;
begin
  GetMem( WastedPtr, 1024 );             { Allocate some memory }
  NumStr := '23b';                     { Invalid Integer String }

  try        { Since try... blocks are blocks, we can nest them }
    try
      Num := StrToInt( NumStr );
    except
      on EConvertError do      { Handle EConvertError exception }
        Num := 0;
    end;
  finally
    MessageDlg( 'About to Free Memory', mtInformation, [mbOk], 0 );
    FreeMem( WastedPtr, 1024 );
  end;
end;


procedure TMainWnd.AverageBtnClick(Sender: TObject);
var
  Sum, Num  : Integer;
  Average   : Real;
  AvgStr    : string;
  Undefined : Boolean;
begin
  Undefined := False;  { Undefined is True if Calculation Fails }
  try
    Sum := StrToInt( SumEdt.Text );    { Convert Text to Number }
    Num := StrToInt( NumItemsEdt.Text );
    Average := Sum / Num;
  except
    on EZeroDivide do        { If Num = 0 then exception raised }
      Undefined := True;

    on EConvertError do
    begin
      MessageDlg( 'Invalid Integer.  Please try again.',
                  mtError, [mbOk], 0 );
      Exit;
    end;
  end; { except }
  if Undefined then
    AverageEdt.Text := 'Undefined'
  else
  begin
    Str( Average:8:2, AvgStr );     { Convert Average to String }
    AverageEdt.Text := AvgStr;  { Set text of control to AvgStr }
  end;
end;


procedure TMainWnd.HitTest;
var
  SMsg : string;
begin
  with MousePt do
  begin
     { Test to see if mouse was clicked on the word 'Exception' }
    if ( X >= 185 ) and ( X <= 270 ) and
       ( Y >= 5 ) and ( Y <= 18 ) then
    begin
                    { If user clicked on 'Exception', raise one }
      SMsg := 'You Clicked on Exception';
      raise EMouseClickError.Create( SMsg );
    end;
  end;
end;


procedure TMainWnd.ClickHereLblClick(Sender: TObject);
begin
  try
    HitTest;
  except
    on EMouseClickError do
      MessageDlg( 'Look, Mom!  I''m Handling EMouseClickError',
                  mtInformation, [mbOk], 0 );
  end;
end;


procedure TMainWnd.ClickHereLblMouseDown(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
  MousePt := Point( X, Y );
end;


begin
  RegisterClasses( [ TMainWnd, TButton, TControl, TWinControl,
                     TListBox, TStrings, TForm, TIcon, TPicture,
                     TGroupBox, TCustomControl, TEdit, TLabel,
                     TPanel ] );
  MainWnd := TMainWnd.Create( Application );
end.

