{ SCRNDEMO.PAS }
{
Description:  This simple Turbo Vision application demonstrates
              the TScrnSaver object, providing some very simple
              animated sprites.

Author:       Don Taylor
Date:         10 April 1994
Last Revised: 11 April 1994 14:45
Application:  IBM PC and compatibles; BP/TP 7.0; Turbo Vision 2.0
}

program ScreenSaverDemo;

uses
 Crt,
 App,
 Objects,
 Menus,
 Drivers,
 Views,
 MsgBox,
 ScrnSave;

const
 { Menu command constants }
 cmScrnSaveEnable  = 200;
 cmScrnSaveDisable = 201;
 cmMessageBox      = 202;

 { Directions for sprites }
 North      =  0;
 East       =  1;
 South      =  2;
 West       =  3;

 { Total number of sprites }
 NumSprites = 30;

 { Screen saver blanking time - minutes }
 BTime      =  1;

type
 SpriteRec = record
  Color   : Byte;   { Sprite color }
  Dir     : Byte;   { Sprite direction }
  DirCntr : Byte;   { Direction move counter }
  XPosn   : Byte;   { X-position }
  YPosn   : Byte;   { Y-position }
 end; { record }

 PFunScrnSaver = ^TFunScrnSaver;
 TFunScrnSaver = object(TScrnSaver)
  SpriteArray : array[1..NumSprites] of SpriteRec;
  SpriteNum : Word;   { Index into sprite array }
  ScrnCntr  : Word;   { Mod counter to slow screen update }

  procedure InitScreen; virtual;
  procedure UpdateScreen; virtual;
 end; { object }

 TApp = object(TApplication)
  ScreenSaver : PFunScrnSaver;

  constructor Init;
  destructor Done; virtual;
  procedure InitMenubar; virtual;
  procedure GetEvent(var Event : TEvent); virtual;
  procedure Idle; virtual;
  procedure HandleEvent(var Event : TEvent); virtual;
 end; { object }

var
 DemoApp : TApp;


{=========================}
{  TFunScrnSaver Methods  }
{=========================}

{--------------------
  InitScreen initializes the array of
  sprites, giving each a random color,
  a random starting position and
  a random direction.
---------------------}
procedure TFunScrnSaver.InitScreen;
var
 i : Integer;
begin
 SpriteNum := 1;
 ScrnCntr  := 0;
 Randomize;
 for i := 1 to NumSprites do
  with SpriteArray[i] do
   begin
    if ScreenMode = smCO80
     then Color := Random(15) + 1   { Anything but black if color }
     else Color := 15;              { White if monochrome }

    Dir     := Random(West + 1);
    DirCntr := 0;
    XPosn   := Random(ScreenWidth - 1) + 1;
    YPosn   := Random(ScreenHeight) + 1;
   end; { with }
end; { TFunScrnSaver.InitScreen }

{--------------------
  UpdateScreen updates the position and/or
  direction of the next sprite in the array.
---------------------}
procedure TFunScrnSaver.UpdateScreen;
var
 X : Byte;  { Buffer for XPosn }
 Y : Byte;  { Buffer for YPosn }
 D : Byte;  { Buffer for Dir }
begin
 Inc(ScrnCntr);
 if ScrnCntr mod 100 = 0
  then begin
        Randomize;
        with SpriteArray[SpriteNum] do
         begin
          { Randomly change direction }
          Inc(DirCntr);
          if DirCntr mod (Random(14) + 1) = 0 then Dir := Random(West + 1);

          X := XPosn;
          Y := YPosn;
          D := Dir;

          { Change position - or direction }
          Randomize;
          case Dir of
           North : if YPosn > 1
                    then Dec(YPosn)
                    else D := Random(West + 1);
           South : if YPosn < ScreenHeight
                    then Inc(YPosn)
                    else D := Random(West + 1);
           East  : if XPosn < ScreenWidth - 1
                    then Inc(XPosn)
                    else D := Random(West + 1);
           West  : if XPosn > 1
                    then Dec(XPosn)
                    else D := Random(West + 1);
          end; { case }

          Dir := D;

          { Black out current position }
          gotoxy(X, Y);
          TextColor(0);
          Write(#219);

          { Update new position }
          gotoxy(XPosn, YPosn);
          TextColor(Color);
          Write(#219);
         end; { with }

        { Update the sprite index }
        Inc(SpriteNum);
        if SpriteNum > NumSprites then SpriteNum := 1;
       end;
end; { TFunScrnSaver.UpdateScreen }


{=========================}
{      TApp Methods       }
{=========================}

{--------------------
  Init constructs a new application
  object.
---------------------}
constructor TApp.Init;
begin
 inherited Init;
 ScreenSaver := New(PFunScrnSaver, Init);
 ScreenSaver^.EnableBlanking(BTime);
 DisableCommands([cmScrnSaveEnable]);
end; { TApp.Init }

{--------------------
  Done disposes of any objects not
  owned by the Desktop.
---------------------}
destructor TApp.Done;
begin
 Dispose(ScreenSaver, Done);
 inherited Done;
end; { TApp.Done }

{--------------------
  InitMenuBar initializes a special
  menu bar for this application.
---------------------}
procedure TApp.InitMenuBar;
var
 R : TRect;
begin
 GetExtent(R);
 R.B.Y := R.A.Y + 1;
 MenuBar := New(PMenuBar, Init(R, NewMenu(
  NewSubMenu('~S~creensaver', hcNoContext, NewMenu(
   NewItem('~E~nable', 'F3', kbF3, cmScrnSaveEnable, hcNoContext,
   NewItem('~D~isable', 'F4', kbF4, cmScrnSaveDisable, hcNoContext,
   NewLine(
   NewItem('~M~essage box', 'F5', kbF5, cmMessageBox, hcNoContext,
   NewLine(
   NewItem('E~x~it', 'Alt-X', kbAltX, cmQuit, hcNoContext,
   nil))))))),
  nil)
 )));
end; { TApp.InitMenuBar }

{--------------------
  The GetEvent procedure provides an
  interface to the ScreenSaver.
---------------------}
procedure TApp.GetEvent(var Event: TEvent);
begin
 inherited GetEvent(Event);
 if ScreenSaver <> nil
  then if Event.What <> evNothing
   then begin
         { The following line "eats" a keypress that causes
           a screen to "unblank". Remove it if you want the
           key to be passed on to the application. }
         if ScreenSaver^.Blanked then Event.What := evNothing;

         ScreenSaver^.ResetTimer;
        end;
end; { TApp.GetEvent }

{--------------------
  The Idle procedure calls the Update
  method of the ScreenSaver.
---------------------}
procedure TApp.Idle;
begin
 inherited Idle;
 ScreenSaver^.Update;
end; { TApp.Idle }

{--------------------
  HandleEvent processes the menu
  commands.
---------------------}
procedure TApp.HandleEvent(var Event : TEvent);
begin
 inherited HandleEvent(Event);
 if Event.What = evCommand
  then case Event.Command of
        cmScrnSaveEnable :
         begin
          ScreenSaver^.EnableBlanking(BTime);
          EnableCommands([cmScrnSaveDisable]);
          DisableCommands([cmScrnSaveEnable]);
         end;

        cmScrnSaveDisable :
         begin
          ScreenSaver^.DisableBlanking;
          EnableCommands([cmScrnSaveEnable]);
          DisableCommands([cmScrnSaveDisable]);
         end;

        cmMessageBox :
         begin
          MessageBox(#3 + 'Blanking will still happen, even with '
             + 'this dialog box on the screen!', nil,
             mfInformation or mfOKButton);
         end;
       end; { case }
end; { TApp.HandleEvent }

{====================}
begin
 DemoApp.Init;
 DemoApp.Run;
 DemoApp.Done;
end.
