; rampdac
;	This function takes a pointer to a gray LUT and pushes
; the corresponding gray values into the DAC on a standard VGA
; card.  For purposes of anti-aliased line-drawing, the LUT
; is filled with a linear ramp (0-255) or a gamma correction
; function.
;
; Copyright (C) 1993 by Nicholas Wilt.  All rights reserved.

.MODEL	COMPACT,C

.CODE

	PUBLIC	rampdac

rampdac	PROC	USES DS SI,dac:DWORD
	lds	si,dac			; Get pointer to OLUT
	mov	dx,03c8h		; Set up for a blitz-write
	mov	ax,bx			;    from this register
	cli				; Critical section:  no ints
	cld				; String ops postincrement
	xor	ax,ax			; Starting register: 0
	out	dx,al			;
	inc	dx			; Set up to update colors
	mov	cx,256			;   (256 of them)
doit:	lodsb				;
	out	dx,al			;
	out	dx,al			;
	out	dx,al			;
	loop	doit			; Loop until done

	sti				; Reset interrupts
	ret				; Triumphant return :-)
rampdac	ENDP

	END

