program TestValidators;

uses
  WinTypes, WinProcs, OWindows, ODialogs, Objects,
  Strings, Validate, ExValDtr, BttrEdit;

{$R VALTEST.RES}

const
  id_FilterEdt     = 101;                  { Dialog Control IDs }
  id_RangeEdt      = 102;
  id_StringEdt     = 103;
  id_PictureEdt    = 104;
  id_RequiredEdt   = 105;
  id_CaseEdt       = 106;
  id_ValidateChk   = 110;
  id_ValOnTabChk   = 111;
  id_CaseChangeCbx = 112;
  cm_Test          = 101;

type
  PTestDialog = ^TTestDialog;
  TTestDialog = object( TDialog )
    FilterEdt, RangeEdt, StringEdt, PictureEdt : PEdit;
    RequiredEdt, CaseEdt : PEdit;
    ValidateChk, ValOnTabChk : PCheckBox;
    CaseChangeCbx : PComboBox;

    constructor Init( AParent : PWindowsObject; AName : PChar );
    procedure SetupWindow; virtual;
    procedure AttachValidators;
    procedure OnValidateClick( var Msg : TMessage );
      virtual id_First + id_ValidateChk;
    procedure OnValidateOnTabClick( var Msg : TMessage );
      virtual id_First + id_ValOnTabChk;
    procedure OnCaseChange( var Msg : TMessage );
      virtual id_First + id_CaseChangeCbx;
  end;


  PMainWindow = ^TMainWindow;
  TMainWindow = object( TWindow )
    constructor Init( AParent : PWindowsObject; AName : PChar );
    procedure CMTest( var Msg : TMessage );
      virtual cm_First + cm_Test;
  end;


  TValTestApplication = object( TApplication )
    procedure InitMainWindow; virtual;
  end;


  {=========================}
  {== TTestDialog Methods ==}
  {=========================}

  constructor TTestDialog.Init( AParent : PWindowsObject;
                                AName : PChar );
  begin
    inherited Init( AParent, AName );

    { Create All the Interface Objects }
    FilterEdt   := New( PBetterEdit,
                        InitResource( @Self, id_FilterEdt, 20 ) );
    RangeEdt    := New( PBetterEdit,
                        InitResource( @Self, id_RangeEdt, 20 ) );
    StringEdt   := New( PBetterEdit,
                        InitResource( @Self, id_StringEdt, 20 ) );
    PictureEdt  := New( PBetterEdit,
                        InitResource( @Self, id_PictureEdt, 20 ) );
    RequiredEdt := New( PBetterEdit,
                        InitResource( @Self, id_RequiredEdt, 20 ) );
    CaseEdt     := New( PBetterEdit,
                        InitResource( @Self, id_CaseEdt, 20 ) );

    ValidateChk  := New( PCheckBox,
                         InitResource( @Self, id_ValidateChk ) );
    ValOnTabChk  := New( PCheckBox,
                         InitResource( @Self, id_ValOnTabChk ) );
    CaseChangeCbx := New( PComboBox,
                     InitResource( @Self, id_CaseChangeCbx, 10 ) );
  end; {= TTestDialog.Init =}


  procedure TTestDialog.SetupWindow;
  begin
    inherited SetupWindow;
    AttachValidators;                   { Attach the validators }
    ValidateChk^.Check;
    ValOnTabChk^.Check;
    CaseChangeCbx^.AddString( 'Upper' );
    CaseChangeCbx^.AddString( 'Lower' );
    CaseChangeCbx^.AddString( 'Mixed' );
    CaseChangeCbx^.SetSelIndex( 0 );    { Select 'Upper' in Cbx }
  end; {= TTestDialog.SetupWindow =}


  procedure TTestDialog.AttachValidators;
  var
    StrColl : PStringCollection;
  begin
    FilterEdt^.SetValidator( New( PFilterValidator,
                                  Init( [ '0'..'9', '.' ] ) ) );

    RangeEdt^.SetValidator( New( PRangeValidator, Init( 1, 50 ) ) );

    { Must use NewStr to Insert strings into collection }
    StrColl := New( PStringCollection, Init( 8, 8 ) );
    StrColl^.Insert( NewStr( 'Mickey' ) );
    StrColl^.Insert( NewStr( 'Donald' ) );
    StrColl^.Insert( NewStr( 'Goofy' ) );
    StringEdt^.SetValidator( New( PStringLookupValidator,
                                  Init( StrColl ) ) );

    { The time format mask must be followed by the user pressing}
    { an 'a' or a 'p', then the 'm' gets displayed automatically}
    PictureEdt^.SetValidator( New( PPXPictureValidator,
                                   Init( '##:## {a,p}m', True ) ) );

    RequiredEdt^.SetValidator( New( PReqFieldValidator, Init ) );

    CaseEdt^.SetValidator( New( PCaseValidator, Init( Upper ) ) );
  end; {= TTestDialog.AttachValidators =}


  procedure TTestDialog.OnValidateClick( var Msg : TMessage );

    procedure ClearValidators( P : PWindowsObject ); far;
    begin
                    { Make sure P points to the correct control }
      if TypeOf( P^ ) = TypeOf( TBetterEdit ) then
        PBetterEdit( P )^.SetValidator( nil );
    end; { ClearValidators }

  begin
    if ValidateChk^.GetCheck = bf_Checked then
    begin
      EnableWindow( ValOnTabChk^.HWindow, True );
      EnableWindow( CaseChangeCbx^.HWindow, True );
      AttachValidators;
    end
    else
    begin
      EnableWindow( ValOnTabChk^.HWindow, False );
      EnableWindow( CaseChangeCbx^.HWindow, False );
      ForEach( @ClearValidators );
    end;
  end; {= TTestDialog.OnValidateClick =}


  procedure TTestDialog.OnValidateOnTabClick( var Msg : TMessage );
  var
    TabOn : Boolean;

    procedure SetEditStyle( P : PWindowsObject ); far;
    begin
                    { Make sure P points to the correct control }
      if TypeOf( P^ ) = TypeOf( TBetterEdit ) then
        with PBetterEdit( P )^.Attr do
        begin
          if TabOn then
            Style := Style or es_ValidateOnTab
          else
            Style := Style and not es_ValidateOnTab;
        end;
    end; { SetEditStyle }

  begin
    TabOn := ValOnTabChk^.GetCheck = bf_Checked;
    ForEach( @SetEditStyle );
  end; {= TTestDialog.OnValidateOnTabClick =}


  procedure TTestDialog.OnCaseChange( var Msg : TMessage );
  begin
    case Msg.LParamHi of
      cbn_SelChange:
      begin
           { Recreate the validator when user changes combo box }
        case CaseChangeCbx^.GetSelIndex of
          0:
            CaseEdt^.SetValidator( New( PCaseValidator,
                                        Init( Upper ) ) );
          1:
            CaseEdt^.SetValidator( New( PCaseValidator,
                                        Init( Lower ) ) );
          2:
            CaseEdt^.SetValidator( New( PCaseValidator,
                                        Init( Mixed ) ) );
        end;
      end; { cbn_SelChange }

    end; { case }
  end; {= TTestDialog.OnCaseChange =}


  {=========================}
  {== TMainWindow Methods ==}
  {=========================}

  constructor TMainWindow.Init( AParent : PWindowsObject;
                                AName : PChar );
  begin
    inherited Init( AParent, AName );

    Attr.Menu := LoadMenu( HInstance, 'MainMenu' );
  end; {= TMainWindow.Init =}


  procedure TMainWindow.CMTest( var Msg : TMessage );
  var
    Dialog : PTestDialog;
  begin
    Dialog := New( PTestDialog, Init( @Self, 'TestDlg' ) );
    Application^.ExecDialog( Dialog );
  end; {= TMainWindow.CMTest =}


  {=================================}
  {== TValTestApplication Methods ==}
  {=================================}

  procedure TValTestApplication.InitMainWindow;
  begin
    MainWindow := New( PMainWindow, Init( nil, 'Validator Test' ) );
  end;


var
  ValTestApp : TValTestApplication;

begin {=== MAIN ===}
  ValTestApp.Init( 'Validate' );
  ValTestApp.Run;
  ValTestApp.Done;
end. {=== MAIN ===}
