/* REXX - TIMECHK.CMD (for OS/2)
*    TIMECHK is used either to calibrate the realtime clock, or
*  to reset it to a time standard.
*    To calibrate:  Call with 'TIMECHK' - A message will be
*  displayed reporting the last time the system clock was reset,
*  followed by the system-clock time-of-day being displayed
*  continuously (in place) until a key is pressed.
*    To reset:  Call with 'TIMECHK R' - After querying, to make
*  sure you really want to reset the system clock, the system
*  'TIME' command will be used, after which the TIMECHK.CMD file
*  will be rewritten showing the date and time of the reset.
*            Copyright (C) 1994 by Murray L. Lesser
*/
    call RxFuncAdd 'SysCurPos', 'RexxUtil', 'SysCurPos'
    call RxFuncAdd 'SysGetKey', 'RexxUtil', 'SysGetKey'
    say
    say "Today is" date('W')||"," date('L')
    parse value stream("TIMECHK.CMD", 'C', 'query datetime'),
            with filedate filetime stuff
    say "The system clock was last reset on" filedate,
           "at" left(filetime,5)
    say
    arg entry
    if left(entry,1) = "R" then signal reset    /* Reset clock */
/* Otherwise, run the normal calibration procedure */
    say "(Press any key to stop the time display)"
    parse value SysCurPos() with row col
    if row = 24 then row = 23
    messge = "     The system clock now reads "
    say messge
    do while chars() = 0
        call SysCurPos row, length(messge)
        say left(time('L'),11)
        end
    signal fini
reset:  /* Use system "Time" command to reset clock */
    call clearkey
    messge = "Do you really want to reset the real-time clock",
             "[y/n]?  "
    parse value SysCurPos() with row col
    if row = 24 then row = 23
    say messge
    call SysCurPos row, length(messge)
    parse upper value SysGetKey('noecho') with answer
    if answer <> 'Y' then do
        say "No"
        signal fini
        end
    else do
        say "Yes"
        say "  Using the OS/2 system TIME command",
              "to reset clock--"
        "@time"
/* Update TIMECHK.CMD file date and time */
        "@copy TIMECHK.CMD /B +,, >NUL"
        signal fini
        end
clearkey:        /* Clear keyboard buffer */
    do while chars() <> 0
        call SysGetKey('noecho')
        end
    return
fini:    /* Return to system */
    say
    call clearkey
    say "Press a key to return to system..."
    call SysGetKey('noecho')
    exit
/* End of timechk.cmd file */
