#include <windows.h> 
#include <memory.h>
#include "mapi.h"  

static ULONG (FAR PASCAL *lpfnMAPILogon)(ULONG, LPSTR, LPSTR,
                                         FLAGS, ULONG, LPLHANDLE);
static ULONG (FAR PASCAL *lpfnMAPILogoff)(LHANDLE, ULONG,
                                          FLAGS,ULONG);
static ULONG (FAR PASCAL *lpfnMAPISendMail)(LHANDLE, ULONG,
                                            lpMapiMessage, FLAGS,
                                            ULONG);

// Send()
//
// Simple MAPI wrapper function to allow the simplest
//  possible MAPI usage.
//
// Returns
//   zero      failed
//   non-zero  success

int Send (LPSTR lpszText) {
   HANDLE hLib;
   ULONG ulResult; 
   LHANDLE hMAPISession;
   MapiMessage mm; 
   HWND hwnd = GetActiveWindow();

   // Turn off the "File not found" error box.
   SetErrorMode (SEM_NOOPENFILEERRORBOX);
    
   // load MAPI.DLL and get proc addresses for
   //   ogon, send, logoff
   if ((hLib = LoadLibrary ("MAPI.DLL")) < HINSTANCE_ERROR) {
      SetErrorMode (0);
      return 0;
   }

   if (((FARPROC)lpfnMAPILogon =
        GetProcAddress (hLib,"MAPILogon")) == NULL)
      return 0;

   if (((FARPROC)lpfnMAPILogoff =
        GetProcAddress (hLib,"MAPILogoff")) == NULL)
      return 0;

   if (((FARPROC)lpfnMAPISendMail =
        GetProcAddress (hLib,"MAPISendMail")) == NULL)
      return 0;

   // Turn "File not found" error box back on.
   SetErrorMode (0);
   
   // Get a MAPI session  
   ulResult = (*lpfnMAPILogon)(hwnd, NULL, NULL,
                               MAPI_NEW_SESSION | MAPI_LOGON_UI,
                               0L, (LPLHANDLE)&hMAPISession);
                               
   if (ulResult != SUCCESS_SUCCESS) 
      return 0;

   // do the mail compose window
   _fmemset (&mm, 0, sizeof(MapiMessage)); 
   if (lpszText && *lpszText)
      mm.lpszNoteText = lpszText;
   ulResult = (*lpfnMAPISendMail)(hMAPISession, hwnd, &mm,
                                  MAPI_DIALOG, 0L);
   // end MAPI session
   (*lpfnMAPILogoff)(hMAPISession, hwnd, 0L, 0L);
    
   // free MAPI.DLL
   FreeLibrary (hLib);
                               
   return ulResult == SUCCESS_SUCCESS ? 1 : 0;
}
