/* Numeric edit control DLL -- Williams
Borland: bcc -2 -v -WD numeditc.c
Microsoft: cl -G2 -Zi -ASw -GD numeditc.c numeditc.def
*/
#include <windows.h>

FARPROC editproc;  // old edit proc
HANDLE dllinst;    // DLL's instance


/* Restrict input to numeric */
LONG WINAPI _export numedit(HWND w,UINT cmd,
   WPARAM wParam,LPARAM lParam)
   {
   if (cmd==WM_CHAR&&wParam>=' '&&(wParam<'0'||wParam>'9'))
      {
      MessageBeep(0);
      return 0L;
      }
   return editproc?
     CallWindowProc(editproc,w,cmd,wParam,lParam):
     0;
   }

/* WIN16 entry point */
int FAR PASCAL LibMain(HINSTANCE mod, WORD ds, WORD heap,
   LPSTR cmdline)
  {
  WNDCLASS wc;
  if (heap>0) UnlockData(0);
  dllinst=mod;
/* Superclass control */
  GetClassInfo(NULL,"Edit",&wc);
  editproc=(FARPROC)wc.lpfnWndProc;
  wc.lpfnWndProc=numedit;
  wc.style|=CS_GLOBALCLASS;
  wc.lpszClassName="NUMEDIT";
  wc.hInstance=mod;
  return RegisterClass(&wc);
  }

/* Win 16 Exit point */
#ifdef __BORLANDC__
int FAR PASCAL WEP(int bSysExit)
#else
int FAR PASCAL _WEP(int bSysExit)
#endif
  {
/* Remove class */
  UnregisterClass("NUMEDIT",dllinst);
  return 1;
  }

#ifdef WIN32
/* Convert Single WIN32 entry point to WIN16 calls */
BOOL DllEntryPoint(HANDLE mod,DWORD reason,LPVOID rsvd)
  {
  switch (reason)
    {
    case DLL_PROCESS_ATTACH:
      return LibMain(mod,0,0,NULL);

    case DLL_PROCESS_DETACH:
#ifdef __BORLANDC__
      return WEP(FALSE);
#else
      return _WEP(FALSE);
#endif
      break;

    }
  return TRUE;
  }

#endif
