/* Numeric edit demo -- Williams
Borland: bcc -v -2 -WS -DUSESUPER=x numedit.c
         brc numedit.rc numedit.exe
Microsoft: cl -Zi -G2 -GA -DUSESUPER=x numedit.c
              numedit.def
           rc numedit.rc numedit.exe

x=0 to build subclass
x=1 to build superclass (requires NUMEDITC.DLL)
*/
#include <windows.h>

#ifndef USESUPER
/* Use superclass if 1; if 0 use subclass */
#define USESUPER 0
#endif

#if !USESUPER
FARPROC editproc;  // old edit procedure
LONG WINAPI _export numedit(HWND w,UINT cmd,WPARAM wParam,
   LPARAM lParam);
FARPROC subclass(HWND w,FARPROC p);
#endif

BOOL WINAPI maindlg(HWND dlg,UINT cmd,WPARAM wParam,
  LPARAM lParam)
  {
  switch (cmd)
    {
    case WM_INITDIALOG:
      {
#if !USESUPER
      editproc=subclass(GetDlgItem(dlg,10),(FARPROC)numedit);
#endif
      return TRUE;
      }

    case WM_COMMAND:
      if (wParam==IDOK)
        {
        EndDialog(dlg,TRUE);
        return TRUE;
        }
    }
  return FALSE;
  }

/* Main window function */
int PASCAL  WinMain(HANDLE hInst, HANDLE prev,
                   LPSTR cmdline, int show)
   {
#if USESUPER
    HANDLE dll;
    dll=LoadLibrary("NUMEDITC.DLL");
    if (!dll) MessageBox(NULL,"Can't load NUMEDITC.DLL",
      NULL,MB_OK|MB_ICONSTOP);
#endif
    DialogBox(hInst,"MainDlg",NULL,maindlg);
#if USESUPER
    if (dll) FreeLibrary(dll);
#endif
    return TRUE;
    }

#if !USESUPER
/* Restrict input to numeric */
LONG WINAPI _export numedit(HWND w,UINT cmd,WPARAM wParam,
   LPARAM lParam)
  {
  if (cmd==WM_CHAR&&wParam>=' '&&(wParam<'0'||wParam>'9'))
    {
    MessageBeep(0);
    return 0L;
    }
  return editproc?CallWindowProc(editproc,w,cmd,
    wParam,lParam):0;
  }

/* Subclass window */
FARPROC subclass(HWND w,FARPROC p)
  {
  if (!IsWindow(w)||!p) return 0L;
  return (FARPROC)SetWindowLong(w,GWL_WNDPROC,(DWORD)p);
  }
#endif
