; Convert far pointer to linear (absolute) address.
; Works with any memory model.
;  Assemble:  tasm /ml/t/w2/z linear;
; Prototype:  unsigned long far pascal linear(void far *);

    .model     small, pascal
     .code

    public     LINEAR
    LINEAR     proc far

       arg     fpb:far ptr byte

       sub     dx, dx         ;init high word of return
       les     bx, [fpb]
       mov     ax, es         ;get segment
        or     ax, bx         ;check offset
        jz     Exit           ;if (fpb == (void far *) 0)
;----------------------------------------------------------
       mov     ax, es
       and     ax, bx
       inc     ax
        jz     MinusOne       ;if (fpb == (void far *)-1L)
;----------------------------------------------------------
       mov     cl, 4
       mov     ax, es
       mov     dl, ah         ;move upper 4 bits
       shr     dl, cl         ; into DX
       shl     ax, cl         ;DX:AX = segment * 10h
       add     ax, bx         ;add in offset
       adc     dl, dh         ;pick up overflow
Exit:
       ret                    ;return long in DX:AX
MinusOne:
       mov     dl, 10h        ;return 0010:0000 in DX:AX
       ret
    LINEAR     endp

       end
