/******************************************************************
 * drawline: Routine for doing line drawing.  Implemented using
 * Bresenham's algorithm.
 *
 * The function assumes an external function called Plot()
 * can be called to plot points on the line.
 *
 * Copyright (C) 1993 by Nicholas Wilt.  All rights reserved.
 *****************************************************************/

extern void Plot(int, int, unsigned char);

void
drawline(int x1, int y1, int x2, int y2, int clr)
{
    int dx, dy, sx, sy;
    int d, numpix;

    dx = x2 - x1;
    dy = y2 - y1;
    if (dx)
	sx = (dx < 0) ? -1 : 1;
    else sx = 0;
    if (dy)
	sy = (dy < 0) ? -1 : 1;
    else sy = 0;
    if (dx < 0) 
	dx = -dx;
    if (dy < 0) 
	dy = -dy;
    Plot(x1, y1, clr);
    Plot(x2, y2, clr);
    if (dx == 0 && dy == 0)
	return;
    if (dx > dy) {
	d = dx / 2;
	numpix = dx;
	while (numpix--) {
	    Plot(x1, y1, clr);
	    d += dy;
	    x1 += sx;
	    if (d > dx) {
		d -= dx;
		y1 += sy;
	    }
	}
    }
    else {
	d = dy / 2;
	numpix = dy;
	while (numpix--) {
	    Plot(x1, y1, clr);
	    d += dx;
	    y1 += sy;
	    if (d > dy) {
		d -= dy;
		x1 += sx;
	    }
	}
    }
}

