; Inner loop to draw a single texture-mapped vertical column,
; rather than a horizontal scanline. Maxed-out 32-bit version.
;
; At this point:
;       EAX = sum of integral X & Y source pointer advances
;       ECX = source pointer increment to advance one in Y
;       EDX = fractional source texture Y coordinate in lower
;             15 bits of DX, fractional source texture X coord
;             in high word of EDX, bit 15 set to 0
;       ESI = initial source texture pointer
;       EDI = initial destination pointer
;       EBP = fractional Y advance in lower 15 bits of BP,
;             fractional X advance in high word of EBP, bit
;             15 set to 0

SCANOFFSET=0

	REPT LOOP_UNROLL

        mov     bl,[esi] ;get image pixel
	add	edx,ebp	 ;advance frac Y in DX,
			 ; frac X in high word of EDX
	adc	esi,eax	 ;advance source pointer by integral
			 ; X & Y amount, also accounting for
			 ; carry from X fractional addition
        mov     [edi+SCANOFFSET],bl ;set screen pixel
				; (located here to avoid 486
				; AGI from previous byte op)
	test	dh,80h    ;carry from Y fractional addition?
	jz	short @F  ;no
	add	esi,ecx   ;yes, advance Y by one
			  ; (produces Pentium AGI for MOV BL,[ESI])
	and	dh,not 80h ;reset the Y fractional carry bit
@@:

SCANOFFSET = SCANOFFSET + SCANWIDTH

	ENDM
