; Inner loop to draw a single texture-mapped vertical column,
; rather than a horizontal scanline. Maxed-out 16-bit version.
;
; At this point:
;       AX = source pointer increment to advance one in Y
;       ECX = fractional Y advance in lower 15 bits of CX,
;             fractional X advance in high word of ECX, bit
;             15 set to 0
;       EDX = fractional source texture Y coordinate in lower
;             15 bits of CX, fractional source texture X coord
;             in high word of ECX, bit 15 set to 0
;       SI = sum of integral X & Y source pointer advances
;       DS:DI = initial destination pointer
;       SS:BP = initial source texture pointer

SCANOFFSET=0

	REPT LOOP_UNROLL

        mov     bl,[bp]		   ;get texture pixel
        mov     [di+SCANOFFSET],bl ;set screen pixel

	add	edx,ecx	;advance frac Y in DX,
			; frac X in high word of EDX
	adc	bp,si	;advance source pointer by integral
			; X & Y amount, also accounting for
			; carry from X fractional addition
	test	dh,80h  ;carry from Y fractional addition?
	jz	@F	;no
	add	bp,ax	;yes, advance Y by one
	and	dh,not 80h ;reset the Y fractional carry bit
@@:

SCANOFFSET = SCANOFFSET + SCANWIDTH

	ENDM
