// FIXORIEN.C -- M. Covington 1994 -- Borland C 3.1
// Resets default printer orientation to portrait
// after other software has modified it.

#include <windows.h>
#include <string.h>
#include <stdlib.h>

main(){
  char sa[128], sb[128], *p;   
  int n;

  // Identify the default printer

  if(!GetProfileString("windows","device","?",sa,sizeof(sa)))
    abort();

  // Transform "Printername,Driver,Port:" to "Printername,Port"

  p = strtok(sa,",");            // retrieve first substring
  strcpy(sb,p);
  strcat(sb,",");

  p = strtok(NULL,",");          // skip next substring
  p = strtok(NULL,",");          // but use the third one
  strcat(sb,p);

  n = strlen(sb) - 1;
  if (sb[n] == ':') sb[n] = 0;   // trim off colon at end

  // Check current value and change it if necessary

  if(!GetProfileString(sb,"orientation","?",sa,sizeof(sa)))
    abort();

  if(sa[0] == '?') {
    MessageBox(GetActiveWindow(),
       "Can't determine paper orientation of default printer.",
       "Printer orientation resetter",
       MB_ICONSTOP || MB_OK);
  }
  else if(sa[0] != '1') {
    if(MessageBox(GetActiveWindow(),
	  "Reset paper orientation to Portrait?",
	  sb,
	  MB_YESNO) == IDYES) {
       if(!WriteProfileString(sb,"orientation","1")) abort();
    }
  }
                        
  return(0);
}

