unit ExValdtr;

interface {=== ExValdtr Unit ===}

  uses
    Validate;

  const
    voUpperCase = $1000;
    voLowerCase = $2000;
    voCaseMask  = $3000;

  type
    PReqFieldValidator = ^TReqFieldValidator;
    TReqFieldValidator = object( TValidator )
      function IsValid( const S : String ) : Boolean; virtual;
      procedure Error; virtual;
    end;

    TCaseStyle = ( Upper, Lower, Mixed );

    PCaseValidator = ^TCaseValidator;
    TCaseValidator = object( TValidator )
      constructor Init( CaseStyle : TCaseStyle );
      function IsValidInput( var S : string;
                             SuppressFill : Boolean
                           ) : Boolean; virtual;
    end;


implementation {=== ExValdtr Unit ===}

{$IFDEF Windows}
  uses
    WinTypes, WinProcs, Strings, OWindows;
{$ELSE}
  uses
    MsgBox;
{$ENDIF Windows}


  {================================}
  {== TReqFieldValidator Methods ==}
  {================================}

  function TReqFieldValidator.IsValid( const S : string ) : Boolean;
  begin
    IsValid := S <> '';                 { Invalid if S is empty }
  end; {= TReqFieldValidator.IsValid =}


{$IFDEF Windows}

  procedure TReqFieldValidator.Error;
  begin                                   { Windows Message Box }
    MessageBox(0,'Input has not be specified for a required field.',
               'Validator', mb_IconExclamation or mb_Ok );
  end;

{$ELSE}

  procedure TReqFieldValidator.Error;
  begin                               { TurboVision Message Box }
    MessageBox( 'Input has not be specified for a required field.',
                nil, mfError + mfOkButton );
  end;

{$ENDIF Windows}


  {============================}
  {== TCaseValidator Methods ==}
  {============================}

  constructor TCaseValidator.Init( CaseStyle : TCaseStyle );
  begin
    inherited Init;
    Options := Options and not voCaseMask;    { Clear Case Bits }
    case CaseStyle of
      Upper:
        Options := Options or voUpperCase;

      Lower:
        Options := Options or voLowerCase;
    end; { case }
  end; {= TCaseValidator.Init =}


  function TCaseValidator.IsValidInput( var S : string;
                                        SuppressFill : Boolean
                                      ) : Boolean;
  var
    K : Integer;
  begin
                         { If voMixedCase then just return True }
    if ( Options and voUpperCase = voUpperCase ) or
       ( Options and voLowerCase = voLowerCase ) then
    begin
      K := Length( S );                { Get Index to Last Char }
      if Options and voUpperCase = voUpperCase then
        S[ K ] := UpCase( S[ K ] ) { Force Last Char Upper Case }
      else
      begin                        { Force Last Char Lower Case }
        if ( S[ K ] >= 'A' ) and ( S[ K ] <= 'Z' ) then
          S[ K ] := Chr( Ord( S[ K ] ) + 32 );
      end;
    end;
    IsValidInput := TRUE;
  end; {= TCaseValidator.IsValidInput =}

end. {=== ExValdtr Unit ===}