/*
 * diskchk.c
 */

#include <bios.h>
#include <dir.h>
#include <dos.h>
#include <errno.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define FALSE 0
#define TRUE 1

/* drive_error is FALSE if the drive is ready */
static int drive_error = FALSE;         

/* Current directory */
static char curdir[MAXDIR+1];

/*
 * test_drive_ready returns TRUE if the drive is ready.
 *
 * Parameter drive is an integer, 0 = drive A, 1 = drive B, etc.
 */
int
test_drive_ready (int drive)
{
        int return_value = FALSE;
        char rootdir[5];

        curdir[0] = '\\';
        getcurdir (0,&curdir[1]);

        /*
         * Try to change to the root directory
         * of the drive in question.
         */
        rootdir[0] = 'A' + drive;
        rootdir[1] = ':';
        rootdir[2] = '\\';
        rootdir[3] = '\0';
        if ((chdir (&rootdir[0]) != 0) || drive_error)
                drive_error = FALSE;
        else
                return_value = TRUE;
        chdir (&curdir[0]);

        return return_value;
}

int
critical_error_handler (void)
{
        drive_error = TRUE;
        /* Return to the application and ignore the error */
        hardretn (0);
}

void
init_diskchk (void)
{
        /* Install the critical error handler */
        harderr (critical_error_handler);
}

void main (void)
{
        int i;

        init_diskchk ();
        for (i = 0; i < 5; i++)
        {
                printf ("Testing drive %c - ", i + 'A');
                if (!test_drive_ready (i))
                        printf ("not ");
                printf ("ready\n");
        }
}

