/* Drag and drop control example -- Williams
Demo: Runs notepad. Select file with mouse,
type in entire file name, or drop file from
file manager to open. Works good with a
debugger too!

Borland: bcc -v -2 -WS ddpad.c
         brc ddpad.rc ddpad.exe

Microsoft: cl -GA -G2 -Zi ddpad.c ddpad.def shell.lib
           rc ddpad.rc ddpad.exe
*/
#include <windows.h>
#include <shellapi.h>
#include <stdlib.h>

#define DEMO 1  // set to 1 for DEMO code


ATOM cb_lo,cb_hi;  // atoms for callback

/* Subclass window */
FARPROC subclass(HWND w,FARPROC p)
  {
  if (!IsWindow(w)||!p) return 0L;
  return (FARPROC)SetWindowLong(w,GWL_WNDPROC,(DWORD)p);
  }


/* Drop window proc -- works with any WM_SETTEXT control */
long WINAPI _export drop_wndproc(HWND hWnd, UINT message,
                            UINT wParam, LONG lParam)
   {
/* Always get old procedure */
   FARPROC oldproc=(FARPROC)MAKELONG(
     GetProp(hWnd,MAKEINTATOM(cb_lo)),
     GetProp(hWnd,MAKEINTATOM(cb_hi)));
   if (message==WM_DESTROY)
     {
/* Clean up */
     SetWindowLong(hWnd,GWL_WNDPROC,(DWORD)oldproc);
     RemoveProp(hWnd,MAKEINTATOM(cb_hi));
     RemoveProp(hWnd,MAKEINTATOM(cb_lo));
     DeleteAtom(cb_hi);
     DeleteAtom(cb_lo);
     }
   else if (message==WM_DROPFILES)
     {
     HDROP drop=(HDROP)wParam;
/* Find # of files */
     int n=DragQueryFile(drop,-1,NULL,0);
     char fp[_MAX_PATH];
     if (n>1)
       MessageBox(hWnd,"Can't accept multiple dropped files",
         NULL,MB_OK|MB_ICONSTOP);
     else
       {
       DragQueryFile(drop,0,fp,sizeof(fp));
       SendMessage(hWnd,WM_SETTEXT,0,(DWORD)fp);  // set file
       }
     DragFinish(drop);
/* The next line makes dropping a file send an IDOK to the
   control's parent window -- you could remove
   this if desired */
     PostMessage(GetParent(hWnd),WM_COMMAND,IDOK,0);
     return 0;
     }
/* Chain to old proc */
   return CallWindowProc(oldproc,hWnd,message,wParam,lParam);
   }

/* Set up file drop subclass */
void DropSubclass(HWND w)
  {
  FARPROC p;
  cb_lo=AddAtom("CB_LO");      // make atoms
  cb_hi=AddAtom("CB_HI");
  p=subclass(w,(FARPROC)drop_wndproc);      // do subclass
  SetProp(w,MAKEINTATOM(cb_lo),LOWORD(p));  // store cb
  SetProp(w,MAKEINTATOM(cb_hi),HIWORD(p));
  DragAcceptFiles(w,TRUE);  // ask for drops
  }


#if DEMO
/* DEMO code from here down */
#include <string.h>

#define PROGNAME "NOTEPAD"  // Try your debugger
#define MASK "*.*"          // and *.EXE here!


#define FILE_CB 101
#define PATH 102
char filename[_MAX_PATH]=MASK;

BOOL WINAPI _export maindlg(HWND dlg,UINT cmd,WPARAM wParam,
   LPARAM lParam)
   {
   switch (cmd)
     {
     static HWND w;
     case WM_INITDIALOG:
       {
/* Fill combo box with file names */
       DlgDirListComboBox(dlg,filename,FILE_CB,
         PATH,DDL_DRIVES|DDL_DIRECTORY);
/* Set up subclass */
       DropSubclass(w=GetDlgItem(dlg,FILE_CB));
       }
       return FALSE;

    case WM_COMMAND:
/* On OK or double click */
      if (HIWORD(lParam)==CBN_DBLCLK||wParam==IDOK)
        {
        if (!DlgDirSelectComboBoxEx(dlg,filename,
          sizeof(filename),FILE_CB))
          {
/* Get entered (not selected) filename */
          SendMessage(w,WM_GETTEXT,
            sizeof(filename),(DWORD)filename);
          EndDialog(dlg,0);
          }
        else
          {
/* process drive/directory */
          lstrcat(filename,MASK);
          DlgDirListComboBox(dlg,filename,FILE_CB,
            PATH,DDL_DRIVES|DDL_DIRECTORY);
          }
        return TRUE;
        }
     }
   return FALSE;
   }

int PASCAL WinMain(HANDLE hInst, HANDLE prev,
  LPSTR cmdline, int show)
  {
  char runstr[129];
  DialogBox(hInst,"MainDlg",NULL,maindlg);
  if (*filename)
    {
    lstrcpy(runstr,PROGNAME " ");
    if (!strchr(filename,'.')) lstrcat(filename,".");
    lstrcat(runstr,filename);
    WinExec(runstr,SW_SHOW);
    }
  return TRUE;
  }
#endif
