{= TBetterEdit is a specialized ObjectWindows Edit control. =}
{= Therefore, this control cannot be used in a Turbo Vision =}
{= Application.                                             =}

unit BttrEdit;

interface {=== BttrEdit ===}

  uses
    WinTypes, OWindows, ODialogs;

  const
    es_ValidateOnTab = $1000;          { New edit style setting }

  type
    PBetterEdit = ^TBetterEdit;
    TBetterEdit = object( TEdit )
    public
      constructor Init( AParent : PWindowsObject; AnId : Integer;
                        ATitle: PChar; X, Y, W, H : Integer;
                        ATextLen : Word; Multiline : Boolean );

      constructor InitResource( AParent : PWindowsObject;
                                ResourceID : Word; ATextLen: Word );

      procedure WMKillFocus( var Msg : TMessage );
        virtual  wm_First + wm_KillFocus;
      procedure WMGetDlgCode( var Msg : TMessage );
        virtual wm_First + wm_GetDlgCode;
    end;


implementation {=== BttrEdit ===}

  {=========================}
  {== TBetterEdit Methods ==}
  {=========================}

  constructor TBetterEdit.Init( AParent : PWindowsObject;
                                AnId : Integer; ATitle: PChar;
                                X, Y, W, H : Integer;
                                ATextLen : Word;
                                Multiline : Boolean );
  begin
    inherited Init( AParent, AnId, ATitle, X, Y, W, H, ATextLen,
                    Multiline );
    Attr.Style := Attr.Style or es_ValidateOnTab;
  end; {= TBetterEdit.Init =}


  constructor TBetterEdit.InitResource( AParent : PWindowsObject;
                                        ResourceID : Word;
                                        ATextLen : Word );
  begin
    inherited InitResource( AParent, ResourceID, ATextLen );
    Attr.Style := Attr.Style or es_ValidateOnTab;
  end; {= TBetterEdit.InitResource =}


  procedure TBetterEdit.WMKillFocus(var Msg: TMessage);
  begin
    if Attr.Style and es_ValidateOnTab = es_ValidateOnTab then
      inherited WMKillFocus( Msg )        { Call Parents Method }
    else
      DefWndProc( Msg );       { Call Default Windows Procedure }
  end; {= TBetterEdit.WMKillFocus =}


  procedure TBetterEdit.WMGetDlgCode(var Msg: TMessage);
  begin
    if Attr.Style and es_ValidateOnTab = es_ValidateOnTab then
      inherited WMGetDlgCode( Msg )       { Call Parents Method }
    else
      DefWndProc( Msg );       { Call Default Windows Procedure }
  end; {= TBetterEdit.WMGetDlgCode =}


end. {=== BttrEdit ===}