/******************************************************************
 * antiline: Routine for doing anti-aliased line drawing.
 * Implemented after Wu's algorithm, described in the SIGGRAPH '91
 * Proceedings.
 *
 * The function assumes an external function called Plot()
 * can be called to plot points on the line.
 *
 * Copyright (C) 1993 by Nicholas Wilt.  All rights reserved.
 *****************************************************************/

extern void Plot(int x, int y, int clr);

void
antiline(int x1, int y1, int x2, int y2, int clr)
{
    int dx, dy, sx, sy;
    unsigned short d, D;

    dx = x2 - x1;
    dy = y2 - y1;
    if (dx)
	sx = (dx < 0) ? -1 : 1;
    else sx = 0;
    if (dy)
	sy = (dy < 0) ? -1 : 1;
    else sy = 0;
    if (dx < 0) dx = -dx;
    if (dy < 0) dy = -dy;
    D = 0;
    Plot(x1, y1, clr);
    Plot(x2, y2, clr);
    if (dx == 0 && dy == 0)
	return;
    if (dx > dy) {
	d = (unsigned short) ((dy * 65535L) / dx);
	if (x1 > x2) {
	    int temp = x1;  x1 = x2;  x2 = temp;
	    temp = y1;  y1 = y2;  y2 = temp;
	    sx = -sx;
	    sy = -sy;
	}
	while (x1 <= x2) {
	    unsigned char pix = (unsigned char) (((long) D*clr) >> 16);
	    D += d;
	    if (D < d) {
		y1 += sy;
		y2 -= sy;
	    }
	    Plot(x1, y1, pix);
	    Plot(x2, y2, pix);
	    if (sy) {
	    	pix = (unsigned char) (((long) (~D)*clr) >> 16);
 		Plot(x1, y1 + sy, pix);
		Plot(x2, y2 - sy, pix);
	    }
	    x1 += sx;
	    x2 -= sx;
	}
    }
    else {
	d = (unsigned short) ((dx * 65535L) / dy);
	if (y1 > y2) {
	    int temp = x1;  x1 = x2;  x2 = temp;
	    temp = y1;  y1 = y2;  y2 = temp;
	    sx = -sx;
	    sy = -sy;
	}
	while (y1 <= y2) {
	    unsigned char pix = (unsigned char) (((long) D*clr) >> 16);
	    D += d;
	    if (D < d) {
		x1 += sx;
		x2 -= sx;
	    }
	    Plot(x1, y1, pix);
	    Plot(x2, y2, pix);
	    if (sx) {
		pix = (unsigned char) (((long) (~D)*clr) >> 16);
		Plot(x1 + sx, y1, pix);
		Plot(x2 - sx, y2, pix);
	    }
	    y1 += sy;
	    y2 -= sy;
	}
    }
}

