program ScreenLock;

{$R SCRLOCK.RES}                    { Resource contains an icon }

uses
  OWindows, WinTypes, WinProcs, Win31, Strings;


type
  PScrLockWin = ^TScrLockWin;
  TScrLockWin = object( TWindow )
    procedure SetupWindow; virtual;
  end;

  PScrLockApp = ^TScrLockApp;
  TScrLockApp = object( TApplication )
    procedure InitMainWindow; virtual;
  end;


  procedure TScrLockWin.SetupWindow;
  var
    S : array[ 0..128 ] of Char;
    Msg : String;
  begin
                      { First check if a screen saver is loaded }
    GetPrivateProfileString( 'Boot', 'SCRNSAVE.EXE', '(None)',
                             S, SizeOf( S ), 'system.ini' );
    if StrComp( S, '(None)' ) <> 0 then
      SendMessage( HWindow, wm_SysCommand, sc_ScreenSave, 0 )
    else
    begin
      Msg := 'No screen saver specified.' + #13;
      Msg := Msg + 'Run Control Panel.' + #0;
      MessageBox( HWindow, @Msg[ 1 ], 'ScrLock Error',
                  mb_Ok or mb_IconStop );
    end;

    PostQuitMessage( 0 );                { Exit the application }
  end; {= TScrLockWin.SetupWindow =}


  procedure TScrLockApp.InitMainWindow;
  begin
    MainWindow := New( PScrLockWin, Init( nil, '' ) );
  end;


var
  ScrLockApp : TScrLockApp;

begin {=== MAIN ===}
  CmdShow := sw_Hide;                    { Hide the main window }

  ScrLockApp.Init( 'Screen Lock' );
  ScrLockApp.Run;
  ScrLockApp.Done;
end.