/*  scrndemo.c - A usage demonstration for the functions in the
* library module: screen.c
*   Compiled with the IBM C/C++ Tools compiler v 2.01 with the
* command-line call: icc /O /Ss scrndemo.c screen.c
*/

#include "screen.h"
#include <string.h>
#include <stdio.h>
#include <conio.h>

char messge[81];
char c, *ch;
int  i;

void main(void)
{
    Attr[1] = 0x70;                  // Clear entire screen to
    clearit();                       //  white on black
    Attr[1] = 0x12;                  // Green letters on Blue
    row = 25;                        // Out of window at bottom!
    ColLft = ColRgt = 37;            // "Window" is single column
    for (i = 0; i < 25; i++)  {
        sprintf(messge, "Row %d",i);
        if (pwindow(messge) != 0) {  // Error first time around.
            ColRgt = ColLft + strlen(messge) +1; //Widen to fit
            pwindow(messge);         //  amd try it again
        }
    }
    putscrn();                      // Save current screen image
    ColLft = row = 0;               // Set to upper left corner
    pwindow("Press a key to continue");
    if ((c = getch()) == 0 || c == '\xe0')  // If extended code,
        getch();                    // delete second character
    getscrn();                      // Restore saved image.
    RowTop = 10;                    // Then, make a red box that
    RowBot = 14;                    // will become the border of
    ColLft = 15;                    // a message "window"
    ColRgt = 65;
    Attr[1] = 0x44;                 // Red on Red!
    clearit();
    putscrn();                      // and save this image
    RowTop += 1;
    RowBot -= 1;
    ColLft += 2;
    ColRgt -= 2;
    Attr[1] = 0x7;                   // Clear the bordered window
    clearit();                       //    to white on black
    row = RowTop + 1;
    col = ColLft + 1;
    dwindow("What is your first name?  ");
    KeyInput(messge,18);          // Accepts up to 18 characters
    dwindow("");                  // Insert a blank line
    strcat(messge,", press another key");
    cwindow(messge);
    if ((c = getch() == 0) || c == '\xe0') getch();
    getscrn();                    // Restore red box
    ch = strrchr(messge,',');     // Find the last comma and
    strcpy(ch+2,"press just one more key to quit"); //make new
    Attr[1] = 0x2;                // message in Green on Black
    ColLft = 0;
    RowTop = RowBot = 24;
    ColRgt = ColLft + strlen(messge);
    clearit();
    pwindow(messge);
    if ((c = getch() == 0) || c == '\xe0') getch();
}
