VERSION 2.00
Begin Form frmBrowser 
   Caption         =   "Browse To Do List"
   ClientHeight    =   3930
   ClientLeft      =   1200
   ClientTop       =   1635
   ClientWidth     =   7335
   Height          =   4395
   Left            =   1110
   LinkTopic       =   "Form1"
   ScaleHeight     =   3930
   ScaleWidth      =   7335
   Top             =   1260
   Width           =   7515
   Begin CommandButton btnHideDone 
      Caption         =   "&Hide Completed Items"
      Height          =   495
      Left            =   2820
      TabIndex        =   4
      Top             =   240
      Width           =   2055
   End
   Begin CommandButton btnPurge 
      Caption         =   "&Delete Completed Items"
      Height          =   495
      Left            =   4980
      TabIndex        =   3
      Top             =   240
      Width           =   2175
   End
   Begin CommandButton btnDelItem 
      Caption         =   "&Delete Item"
      Height          =   495
      Left            =   1500
      TabIndex        =   2
      Top             =   240
      Width           =   1215
   End
   Begin CommandButton btnClose 
      Caption         =   "&Close"
      Height          =   495
      Left            =   180
      TabIndex        =   1
      Top             =   240
      Width           =   1215
   End
   Begin ListBox lstBrowser 
      Height          =   2955
      Left            =   180
      Sorted          =   -1  'True
      TabIndex        =   0
      Top             =   840
      Width           =   6975
   End
End
Option Explicit

Dim priorityName(0 To 2) As String
Dim toDoDb As Database
Dim toDoList As Dynaset
Dim lineData As String


Sub btnClose_Click ()
    toDoList.Close
    toDoDb.Close
    Unload Me
End Sub

Sub btnDelItem_Click ()
Dim counterVal As Long
Dim theQuery As String
Dim tmp As String
Dim tmpIndex As Integer

    counterVal& = lstBrowser.ItemData(lstBrowser.ListIndex)
    theQuery$ = "[Counter] =" & Str$(counterVal&)
    toDoList.FindFirst theQuery$
    If Not (toDoList.NoMatch) Then
        toDoList.Delete
    End If
    tmpIndex% = lstBrowser.ListIndex
    lstBrowser.RemoveItem lstBrowser.ListIndex
    If tmpIndex% > lstBrowser.ListCount - 1 Then
        tmpIndex% = lstBrowser.ListCount - 1
    End If
    lstBrowser.ListIndex = tmpIndex%
End Sub

Sub btnHideDone_Click ()
Dim doWhat As String
Dim tmpDs As Dynaset

    toDoList.Close
    Set tmpDs = toDoDb.CreateDynaset("ToDoList")
    doWhat$ = Mid$(btnHideDone.Caption, 2, 4)
    Select Case doWhat$
        Case "Hide"
            tmpDs.Filter = "[Done] = 0"
            tmpDs.Sort = "[Date], [Priority]"
            btnHideDone.Caption = "&Show All"
        Case "Show"
            tmpDs.Sort = "[Done], [Date], [Priority]"
            btnHideDone.Caption = "&Hide Completed Items"
    End Select
    Set toDoList = tmpDs.CreateDynaset()
    tmpDs.Close
    fillList toDoList
End Sub

Sub btnPurge_Click ()
Dim queryPurge As QueryDef
Dim sqlQuery As String

    Set queryPurge = toDoDb.CreateQueryDef("Purge", "Delete From ToDoList Where Done = -1")
    queryPurge.Execute
    queryPurge.Close
    toDoDb.DeleteQueryDef ("Purge")
    toDoList.Close
    sqlQuery$ = "Select * From ToDoList Order by [Counter], [Date], [Priority]"
    Set toDoList = toDoDb.CreateDynaset(sqlQuery$)
    fillList toDoList
End Sub

Sub fillList (ds As Dynaset)
    ds.MoveFirst
    lstBrowser.Clear
    Do Until ds.EOF
        If ds("Done") Then
            lineData$ = "X "
        Else
            lineData$ = "   "
        End If
        lineData$ = lineData$ + priorityName$(ds("Priority"))
        lineData$ = lineData$ + Format$(ds("Date"), "mm-dd-yy ")
        If Not (IsNull(ds("Description"))) Then
            lineData$ = lineData$ + ds("Description")
        Else
            lineData$ = lineData$ + " "
        End If
        lstBrowser.AddItem lineData$
        lstBrowser.ItemData(lstBrowser.NewIndex) = ds("Counter")
        ds.MoveNext
    Loop
End Sub

Sub Form_Load ()
Dim sqlQuery As String

    priorityName$(0) = "Urgent      "
    priorityName$(1) = "Important  "
    priorityName$(2) = "Whenever "
    sqlQuery$ = "Select * From ToDoList Order By [Done], [Date], [Priority]"

    Set toDoDb = OpenDatabase(dataFile$)
    Set toDoList = toDoDb.CreateDynaset(sqlQuery$)
    fillList toDoList
End Sub

Sub lstBrowser_DblClick ()
Dim counterVal As Long
Dim theQuery As String
Dim tmp As String


    counterVal& = lstBrowser.ItemData(lstBrowser.ListIndex)
    theQuery$ = "[Counter] =" & Str$(counterVal&)
    toDoList.FindFirst theQuery$
    If Not (toDoList.NoMatch) Then
        toDoList.Edit
        toDoList("Done") = Not (toDoList("Done"))
        toDoList.Update
    End If
    tmp$ = lstBrowser.List(lstBrowser.ListIndex)
    Mid$(tmp$, 1, 1) = "X"
    lstBrowser.List(lstBrowser.ListIndex) = tmp$
End Sub

