unit WinDlg;

interface {=== WinDlg Unit ===}

uses
  OWindows, ODialogs, Strings, WinProcs;

type
  PWinDialog = ^TWinDialog;
  TWinDialog = object( TDialog )
    Title : PChar;
    constructor Init( AParent : PWindowsObject;
                      AName : PChar; ATitle : PChar );
    destructor Done; virtual;
    procedure SetupWindow; virtual;
    procedure SetCaption( ATitle : PChar );
  end;


implementation {=== WinDlg Unit ===}


{========================}
{== TWinDialog Methods ==}
{========================}

constructor TWinDialog.Init( AParent : PWindowsObject;
                              AName : PChar; ATitle : PChar );
begin
  inherited Init( AParent, AName );
  Title := StrNew( ATitle );         { Allocate space for Title }
end;

destructor TWinDialog.Done;
begin
  StrDispose( Title );           { Free up memory used by Title }
  inherited Done;
end;

procedure TWinDialog.SetupWindow;
begin
  inherited SetupWindow;
           { Now that I have a Window Handle, display the Title }
  if Title <> nil then
    SetWindowText( HWindow, Title );
end;

procedure TWinDialog.SetCaption( ATitle : PChar );
begin
  StrDispose( Title );               { Dispose of current title }
  Title := StrNew( ATitle );     { Allocate space for new title }
  SetWindowText( HWindow, ATitle );     { Display the new title }
end;

end. {=== WinDlg Unit ===}