100 ' V.BAS  (M. Covington 1994)
110 ' Measuring VOLTAGE or CURRENT through joystick port
120 '
130 SENSOR = 0 ' possibilities: 0, 1, 2, 3
140 '
150 CLS
160 PRINT "VOLTAGE/CURRENT PROGRAM"
170 PRINT
180 '
190 ' Calibration
200 '
210 PRINT "Calibration needs 2 known values,"
220 PRINT "preferably near ends of range."
230 '
240 OPTION BASE 1
250 DIM RDG(2), VALUE(2)
260 FOR I = 1 TO 2
270   PRINT
280   PRINT "Connect known value "; I; " and press any key..."
290   WHILE INKEY$ = ""
300     RDG(I) = STICK(0)          ' initialize all 4 sensors
310     IF SENSOR > 0 THEN RDG(I) = STICK(SENSOR)
320     LOCATE CSRLIN, 1
330     PRINT "Reading: "; RDG(I); "      ";
340   WEND
350   PRINT
360   INPUT "Actual value"; VALUE(I)
370 NEXT I
380 '
390 FACTOR = (1 / VALUE(2) - 1 / VALUE(1)) / (RDG(2) - RDG(1))
400 OFFSET = .5 * (1 / VALUE(2) - FACTOR * RDG(2) + 1 / VALUE(1) - FACTOR * RDG(1))
410 '
420 PRINT
430 PRINT "Factor =", FACTOR, "Offset =", OFFSET
440 '
450 ' Taking readings
460 '
470 PRINT
480 PRINT "Taking readings continuously.  Exit with Ctrl-Break."
490 PRINT
500 '
510 WHILE 1
520   RDG = STICK(0)               ' initialize all 4 sensors
530   IF SENSOR > 0 THEN RDG = STICK(SENSOR)   ' take reading
540   VALUE = 1 / (FACTOR * RDG + OFFSET)
550   LOCATE CSRLIN, 1, 0
560   PRINT USING "#### ####.##"; RDG; VALUE;
570 WEND
