; hash - a speedy little hash function
;
; in:  es:si = pointer to string (raw ascii chars, no length byte,
;              no terminator
;      cx    = string length (must be > 0)
;
; out: bx = hash code (offset into 64K hash table)

hash:
         sub  bx,bx   ;clear hash code accumulator
         mov  dx,cx   ;save length for later
         shr  cx,1    ;convert length in bytes to length in words
         je   length1 ;handle 1 byte length as a special case
calc:    lodsw
         add  bx,ax   ;update hash code
         loop calc
         shr  dx,1    ;check if initial length odd or even
         jnc  done
length1: add  al,[si] ;handle odd byte
done:    add  bx,bx   ;convert hash code to word offset
         ret
