/*******************************************************************
*                               VLABEL.C
*     char *vlabel(ULONG DriveNumber), a C private library function
* for OS/2, returns the volume label of the drive designated by
* DriveNumber (0 is default, 1 is A, etc.).  vlabel uses the OS/2
* 2.1 control program function DosQueryFSInfo, Level 2 information.
*     Nomenclature used is from IBM OS/2 2.1 "Control Program
* Programming Reference."
*
*                   Written by M. L. Lesser, 5/2/93
* Compiled with IBM C/C++ Tools v2.0, and OS/2 Toolkit 2.1, 10/6/93
*******************************************************************/

#define INCL_NOPMAPI
#include <os2.h>

char *vlabel(ULONG DriveNumber)
{
    struct {              /* Return from DosQueryFSInfo, level 2 */
        ULONG VolumeSerialNum;
        BYTE  volumelength;    /* Length of label, not inc. null */
        CHAR  volumelabel[12]; /* ASCIIZ string */
        } FSInfoBuff;
    ULONG  FSInfoBuffSize = sizeof(FSInfoBuff);
    APIRET rc;

    rc = DosQueryFSInfo(DriveNumber,2,&FSInfoBuff,FSInfoBuffSize);
    if (rc != 0)                       /* error! */
        FSInfoBuff.volumelabel[0] = 0; /* Force zero-length label */
    return FSInfoBuff.volumelabel;
}
