// Listing 4
//---------------------------------------------------------------
// File: VDRVTEST.CPP
// Author: Brian Hook
//
// Sample program that illustrates using the VDRV class to
// dynamically load executable code at run-time.  This was
// compiled under Borland C++ 3.1 in the large memory model.
//---------------------------------------------------------------
#include <conio.h>
#include <stdlib.h>
#include <stdio.h>
#include "vdrv.h"

void main( void )
{
VDRV test( "sample.drv" );

   printf("VDRVTEST program\n");
   if ( test.GetError() == VDRV_OK ) {
      if ( test.InitDriver( 0 ) == VINIT_OK ) {

         //--- Print out some information -----------------------
         printf("MODE INFO:\n");
         printf("Resolution: %d x %d\n", test.mode_list->width,
                                         test.mode_list->height );
         printf("Color depth: %d bits per pixel\n",
                 test.mode_list->color_depth );
         printf("Pages: %d\n", test.mode_list->pages );

         printf("\nPress a key to begin\n");
         getch();

         //--- Draw some stuff ----------------------------------
         test.StartGraphics( 0 );
         for ( int i = 0; i < test.mode_list->height; i++ )
            for ( int j = 0; j < test.mode_list->width; j++ )
               test.Point( j, i, ( j + i ) & 0xff );

         getch();

         //--- Shut down the driver -----------------------------
         test.EndGraphics();
         test.EndDriver();
      }
      else {
         puts("Could not initialize driver");
         exit( 1 );
      }
   }
   else {
      puts("Driver could not be loaded");
      exit( 1 );
   }
}
