// Listing 1 -- STATE.H:

#ifndef _STATE_H
#define _STATE_H

// -------------------------------------------------------------
//  A very simple point struct.
//
struct TPoint
{
    int x,y;

    TPoint() { x=0; y=0; }
    TPoint(int x_, int y_) { x=x_; y=y_; }
    TPoint operator - () { return TPoint(-x, -y); }
    TPoint operator += (const TPoint &b)
        { x+=b.x; y+=b.y; return *this; }
};

// -------------------------------------------------------------
//  A very simple polygon class.
//
class TPolygon
{
public:
    TPolygon(int nVertices_, TPoint *pVertices_);
    virtual ~TPolygon();

    virtual void Translate(TPoint point);
    virtual void VFlip();

protected:
    int    nVertices;
    TPoint *pVertices;

    virtual void prvTranslate(TPoint point);

    #ifdef NDEBUG
        void CheckState() const {}
    #else
        virtual void CheckState() const;
    #endif
};

// -------------------------------------------------------------
//  A class for rectangles with two horizontal and two vertical
//  sides.  It always maintains its area in its uArea member.
//
class TRectangle : public TPolygon
{
public:
    TRectangle(TPoint *pVertices_);

    // Since this is const, it doesn't call CheckState().
    unsigned GetuArea() const { return uArea; }

protected:
    unsigned uArea;

    unsigned prvCalcArea() const;

    #ifdef NDEBUG
        void CheckState() const {}
    #else
        virtual void CheckState() const;
    #endif
};

#endif // #ifndef _STATE_H
