PROGRAM popups;
  { How to use message boxes and WinExec under WinCrt. }

USES WinCrt, WinTypes, WinProcs;

VAR result: word;

BEGIN
  { How to put up a message box }
  writeln('Hello, this is ordinary output.');
  MessageBox(GetActiveWindow,
     'Look!','This is a message box',MB_OK);
  writeln('Press Return...'); readln;

  { Message box with a choice of responses }
  CASE MessageBox(GetActiveWindow,'Look at this',
     'In this box you make a choice',MB_YESNOCANCEL) OF
    ID_YES: writeln('You said YES');
    ID_NO:  writeln('You said NO');
    ELSE    writeln('You said CANCEL');
  END;

  { How to run any .COM, .EXE, .BAT, or .PIF program }
  writeln('Next we''ll run the Notepad for a moment...');
  write('Press Return...');
  readln;
  result := WinExec('notepad myfile.txt',SW_SHOWNORMAL);
    { Other program runs CONCURRENTLY with this one! }
    { Execution continues here as soon as the        }
    { WinExec'd process STARTS.                      }
  IF result < 32 THEN
    writeln('Couldn''t run it, return code=',result)
  ELSE
    writeln('Running it successfully, thanks');
  writeln('Back to the main window.  Press Return...');
  readln;
END.
