{
Listing 5
MEMTEST.PAS
Simple Program to test the Mem unit with processor-specific DLL's.
Run under Turbo Profiler for Windows to examine performance.
}

program MemTest;

{$IFDEF WINDOWS}              { For Windows 3.1 }
  {$A+,B-,D+,F+,G+,I-,K+,L+,N-,P-,Q-,R-,S-,T-,V+,W-,X+,Y+}
  {$M 8192,8192}
uses Mem, WinCrt;             { For DPMI }
{$ELSE}
  {$A+,B-,D+,E+,F+,G+,I-,L+,N-,P-,Q-,R-,S-,T-,V+,X+,Y+}
  {$M 16384,0}
  uses Mem;
{$ENDIF}

const
  TestCase = 10000;              { Run x times for comparisson }

var
  String1,
  String2  : String;
  Numbers1,
  Numbers2 : Array[1..500] of Integer;
  Count    : Integer;

begin
  { Opening Message }
  writeln('MEMTEST - test processor specific DLLs ');
  writeln('Testing....');
  writeln;

  if MemError then
    Halt(1);                { Initialization procedure failed }
  String1 := 'This is a test';
  String2 := 'Nil';

  { Prove it Works }
  writeln('String 1: ', String1);
  writeln('String 2: ', String2);
  writeln;
  writeln('Copying...');
  FastMove(String1, String2, sizeof(String1));
  writeln('New String2: ', String2);



  { Initialize first 10 elements to 1, and print them };
  writeln;
  write('Initializing array to 1 using For..   : ');
  for Count := 1 to 10 do
  begin
    Numbers1[Count] := 1;
    write(Numbers1[Count],' ');
  end;
  writeln;

  write('Initializing array to 0 using FastFill: ');
  FastFill(Numbers1, sizeof(Numbers1), 0);
  for Count := 1 to 10 do
    write(Numbers1[Count],' ');
  writeln;

  writeln;
  writeln('Comparing new routines to the ones in the System Unit');
  writeln('Use Profiler for Windows to compare speed.');
  writeln;

  for Count := 1 to TestCase do
  begin
    FastFill(Numbers2, sizeof(Numbers2), 0);
    FillChar(Numbers2, sizeof(Numbers2), 0);
    FastMove(Numbers2, Numbers1, sizeof(Numbers2));
    Move    (Numbers2, Numbers1, sizeof(Numbers2));
  end;

  writeln;
  writeln('**Done**');
  writeln;
end.
