{$A+,B-,D+,F+,G+,I-,K+,L+,N-,P-,Q-,R-,S-,T-,V+,W-,X+,Y+}
{$M 8192,8192}
{  Listing 4
  MEM386.PAS
  Implements the 32 bit (80386/i486) version of the library.
  For binary compatability, compile for a Windows target
  (BPC -CW MEM386.PAS or Compile | Target | Windows in the IDE) }

library Mem386;

const
  D32 = $66;                  { 32 bit data }

procedure FastMove(Source, Dest : Pointer; Count : Word); export;
begin
  asm
    CLD                       { Copy Forward }
    DB   D32
    XOR  SI, SI               { XOR ESI, ESI to clear high word }

    DB   D32
    XOR  DI, DI               { XOR EDI, EDI to clear high word }

    DB   D32
    DB   $0F, $B7             { MOVZX ECX, Count }
    DB   $4E, $06

    LDS  SI,  Source          { Load Source address }
    LES  DI,  Dest            { Load Destination Address }

    SHR  CX, 2                { Convert to DWORDS }
    DB   D32
    REP  MOVSW                { REP MOVSD }
    MOV  CX, Count            { Get count again }
    AND  CX, 3                { Get last 0-3 bytes }
    REP MOVSB                 { Move odd bytes, if they exist }
  end;
end;

procedure FastFill(var Source; Count : Word; C: Byte); export;
begin
  asm
    CLD                       { Forward! }

    DB   D32
    XOR  SI, SI               { XOR ESI, ESI }

    DB   D32
    DB   $0F, $B7             { MOVZX ECX, Count }
    DB   $4E, $08

    LES  DI,  Source          { Load Source address }
    MOV  AH, C
    MOV  AL, AH
    PUSH AX                   { Store as a DWORD }
    PUSH AX

    DB   D32
    POP  AX                   { POP EAX }

    SHR  CX, 2                { Convert to DWORDS }
    DB   D32
    REP  STOSW                { REP STOSD }
    MOV  CX, Count
    AND  CX, 3                { Get last four bytes }
    REP  STOSB                { Store them }
  end;
end;

{$I MEMCONST.INC}

exports
  FastMove Index pr_FastMove,
  FastFill Index pr_FastFill;

begin
end.