PROGRAM filedialogs;

USES WinCrt, CommDlg, WinProcs, Strings;

VAR infilename, outfilename: ARRAY[0..63] OF char; {=PChar}
    infile, outfile:         text;
    filedata:                TOpenFileName;
    junk:                    STRING;

BEGIN

writeln('Demonstrating how to select files...');

{ Select a file to READ. }
StrCopy(infilename,'junk.txt'); { put default name here }
FillChar(filedata,sizeof(filedata),0);
WITH filedata DO
  BEGIN
    lStructSize     := sizeof(filedata);
    hWndOwner       := GetActiveWindow;
    lpstrFile       := infilename;
    nMaxFile        := sizeof(infilename);
    lpstrInitialDir := 'C:\JUNK'; { default directory, if any }
    lpstrTitle      := 'File to read';
    lpstrFilter     := 'All Files'#0'*.*'#0; { can be omitted }
    Flags           := OFN_FILEMUSTEXIST +
                       OFN_PATHMUSTEXIST +
                       OFN_READONLY;
  END;
IF NOT GetOpenFileName(filedata) THEN
    writeln('You were supposed to choose a file name!');

{ Now infilename contains the file name. }
writeln('The input will be read from: ',infilename);

{ Select a file to WRITE.  Insist that it not already exist. }
StrCopy(outfilename,'unnamed.txt');  { Put default name here }
FillChar(filedata,sizeof(filedata),0);
WITH filedata DO
  BEGIN
    lStructSize     := sizeof(filedata);
    hWndOwner       := GetActiveWindow;
    lpstrFile       := outfilename;
    nMaxFile        := sizeof(outfilename);
    lpstrInitialDir := 'D:\junk';
    lpstrTitle      := 'File to create';
    lpstrFilter     := 'Text File'#0'*.txt'#0'ASCII File'#0'*.asc'#0;
    Flags           := OFN_OVERWRITEPROMPT +
                       OFN_PATHMUSTEXIST +
                       OFN_HIDEREADONLY +
                       OFN_NOREADONLYRETURN;
    lpstrDefExt     := 'txt'
  END;
  IF NOT GetSaveFileName(filedata) THEN
    writeln('You were supposed to choose a file name!');

  { Now outfilename contains the file name. }
  writeln('The output will be written on: ',outfilename);

  { Trivial demo: copy 1 line from 1 file to the other }
  assign(infile,infilename);   reset(infile);
  assign(outfile,outfilename); rewrite(outfile);
  readln(infile,junk);
  writeln(outfile,'First line was:',junk);
  close(infile);
  close(outfile);
  writeln('All done.');
END.
