// bsearch2.h
//	Function template for an iterative implementation of
//	binary search.
// Copyright (C) 1993 by Nicholas Wilt.  All rights reserved.

template<class T>
T *
BinarySearch(T *base, int N, const T& key)
{
    while (N >= 1) {
	int mid = N / 2;
	if (base[mid] == key)
	    return base + mid;
	if (base[mid] < key) {
	    base += mid + 1;
	    N -= mid + 1;
	}
	else
	    N = mid;
    }
    return 0;
}

