// bsearch1.h
//	Function template for a recursive implementation of
//	binary search.
// Copyright (C) 1993 by Nicholas Wilt.  All rights reserved.

template<class T>
T *
BinarySearch(T *base, int N, const T& key)
{
    if (N < 1)
	return 0;
    int mid = N / 2;
    if (base[mid] == key)
	return base + mid;
    if (base[mid] < key)
	return BinarySearch(base + mid + 1, N - mid - 1, key);
    else
	return BinarySearch(base, mid, key);
}

