VERSION 2.00
Begin Form frmMain 
   BackColor       =   &H00800000&
   Caption         =   "Things To Do"
   ClientHeight    =   5010
   ClientLeft      =   1035
   ClientTop       =   1785
   ClientWidth     =   5775
   Height          =   5760
   Icon            =   DCDEMO.FRX:0000
   KeyPreview      =   -1  'True
   Left            =   945
   LinkTopic       =   "Form1"
   ScaleHeight     =   5010
   ScaleWidth      =   5775
   Top             =   1125
   Width           =   5955
   Begin TextBox txtDescription 
      DataField       =   "Description"
      DataSource      =   "Data1"
      Height          =   315
      Left            =   780
      MaxLength       =   100
      TabIndex        =   8
      Tag             =   "Description"
      Top             =   3000
      Width           =   4035
   End
   Begin MaskEdBox mskDueDate 
      Height          =   315
      Left            =   780
      Mask            =   "##-##-##"
      MaxLength       =   8
      PromptChar      =   "_"
      TabIndex        =   5
      Tag             =   "DueDate"
      Top             =   2160
      Width           =   960
   End
   Begin CheckBox chkDone 
      BackColor       =   &H00808000&
      Caption         =   "Done"
      DataField       =   "Done"
      DataSource      =   "Data1"
      ForeColor       =   &H00FFFFFF&
      Height          =   495
      Left            =   780
      TabIndex        =   4
      Tag             =   "Done"
      Top             =   1320
      Width           =   810
   End
   Begin Frame Frame1 
      BackColor       =   &H00808000&
      Caption         =   "Priority"
      ForeColor       =   &H00FFFFFF&
      Height          =   1200
      Left            =   3270
      TabIndex        =   0
      Top             =   1275
      Width           =   1575
      Begin OptionButton optPriority 
         BackColor       =   &H00808000&
         Caption         =   "Whenever"
         ForeColor       =   &H00FFFFFF&
         Height          =   240
         Index           =   2
         Left            =   150
         TabIndex        =   3
         Tag             =   "Priority"
         Top             =   900
         Width           =   1245
      End
      Begin OptionButton optPriority 
         BackColor       =   &H00808000&
         Caption         =   "Important"
         ForeColor       =   &H00FFFFFF&
         Height          =   255
         Index           =   1
         Left            =   150
         TabIndex        =   2
         Tag             =   "Priority"
         Top             =   585
         Width           =   1245
      End
      Begin OptionButton optPriority 
         BackColor       =   &H00808000&
         Caption         =   "Urgent"
         ForeColor       =   &H00FFFFFF&
         Height          =   240
         Index           =   0
         Left            =   150
         TabIndex        =   1
         Tag             =   "Priority"
         Top             =   300
         Value           =   -1  'True
         Width           =   1245
      End
   End
   Begin Data Data1 
      BackColor       =   &H00FFFFC0&
      Connect         =   ""
      DatabaseName    =   "TODO.MDB"
      Exclusive       =   0   'False
      Height          =   315
      Left            =   780
      Options         =   0
      ReadOnly        =   0   'False
      RecordSource    =   "ToDoList"
      Top             =   4455
      Width           =   4170
   End
   Begin Image Image1 
      Height          =   555
      Left            =   1620
      Picture         =   DCDEMO.FRX:0302
      Top             =   660
      Width           =   2430
   End
   Begin Shape Shape6 
      BackColor       =   &H00404000&
      BackStyle       =   1  'Opaque
      BorderStyle     =   0  'Transparent
      Height          =   315
      Left            =   840
      Top             =   3060
      Width           =   4035
   End
   Begin Label Label2 
      AutoSize        =   -1  'True
      BackStyle       =   0  'Transparent
      Caption         =   "Description:"
      ForeColor       =   &H00FFFFFF&
      Height          =   195
      Left            =   780
      TabIndex        =   7
      Top             =   2760
      Width           =   1035
   End
   Begin Label Label1 
      AutoSize        =   -1  'True
      BackStyle       =   0  'Transparent
      Caption         =   "Due Date:"
      ForeColor       =   &H00FFFFFF&
      Height          =   195
      Left            =   780
      TabIndex        =   6
      Top             =   1905
      Width           =   885
   End
   Begin Shape Shape5 
      BackColor       =   &H00404000&
      BackStyle       =   1  'Opaque
      BorderStyle     =   0  'Transparent
      Height          =   315
      Left            =   840
      Top             =   2220
      Width           =   960
   End
   Begin Shape Shape4 
      BackColor       =   &H00404000&
      BackStyle       =   1  'Opaque
      BorderStyle     =   0  'Transparent
      Height          =   1110
      Left            =   3330
      Top             =   1455
      Width           =   1575
   End
   Begin Line Line10 
      BorderColor     =   &H00000000&
      BorderWidth     =   2
      X1              =   -30
      X2              =   5760
      Y1              =   4200
      Y2              =   4200
   End
   Begin Line Line9 
      BorderColor     =   &H00C0C0C0&
      BorderWidth     =   2
      X1              =   0
      X2              =   5760
      Y1              =   4245
      Y2              =   4245
   End
   Begin Line Line8 
      BorderColor     =   &H00C0C0C0&
      BorderWidth     =   3
      X1              =   390
      X2              =   5280
      Y1              =   465
      Y2              =   465
   End
   Begin Line Line6 
      BorderColor     =   &H00C0C0C0&
      BorderWidth     =   3
      X1              =   390
      X2              =   390
      Y1              =   465
      Y2              =   3645
   End
   Begin Line Line5 
      BorderWidth     =   2
      X1              =   5250
      X2              =   5250
      Y1              =   3630
      Y2              =   540
   End
   Begin Line Line4 
      BorderWidth     =   2
      X1              =   480
      X2              =   5250
      Y1              =   3630
      Y2              =   3645
   End
   Begin Line Line3 
      BorderColor     =   &H00C0C0C0&
      BorderWidth     =   3
      X1              =   525
      X2              =   5145
      Y1              =   570
      Y2              =   570
   End
   Begin Line Line1 
      BorderColor     =   &H00C0C0C0&
      BorderWidth     =   3
      X1              =   495
      X2              =   495
      Y1              =   570
      Y2              =   3555
   End
   Begin Shape Shape2 
      BorderColor     =   &H00FFFFFF&
      BorderWidth     =   2
      Height          =   3075
      Left            =   465
      Top             =   540
      Width           =   4755
   End
   Begin Shape Shape1 
      BackStyle       =   1  'Opaque
      BorderColor     =   &H00FFFFFF&
      BorderWidth     =   3
      FillColor       =   &H00808000&
      FillStyle       =   0  'Solid
      Height          =   3315
      Left            =   345
      Top             =   405
      Width           =   4995
   End
   Begin Shape Shape3 
      BorderStyle     =   0  'Transparent
      FillColor       =   &H00400000&
      FillStyle       =   0  'Solid
      Height          =   3315
      Left            =   465
      Top             =   540
      Width           =   4995
   End
   Begin Menu mnuFile 
      Caption         =   "&File"
      Begin Menu mnuFileSort 
         Caption         =   "&Sort"
         Begin Menu mnuFileSortNone 
            Caption         =   "&None"
         End
         Begin Menu mnuFileSortPriority 
            Caption         =   "&Priority"
         End
         Begin Menu mnuFileSortDueDate 
            Caption         =   "&Due Date"
         End
         Begin Menu mnuFileSortStatus 
            Caption         =   "&Status"
         End
      End
      Begin Menu mnuFileSepBar1 
         Caption         =   "-"
      End
      Begin Menu mnuFileExit 
         Caption         =   "E&xit"
      End
   End
   Begin Menu mnuSearch 
      Caption         =   "&Search"
      Begin Menu mnuSearchFirst 
         Caption         =   "&Find First"
      End
      Begin Menu mnuSearchNext 
         Caption         =   "Find &Next"
      End
      Begin Menu mnuSearchPrevious 
         Caption         =   "Find &Previous"
      End
      Begin Menu mnuSearchLast 
         Caption         =   "Find &Last"
      End
   End
   Begin Menu mnuRecord 
      Caption         =   "&Record"
      Begin Menu mnuRecordAdd 
         Caption         =   "&Add"
      End
      Begin Menu mnuRecordDelete 
         Caption         =   "&Delete"
      End
      Begin Menu mnuRecordSave 
         Caption         =   "&Save"
      End
   End
End
Option Explicit

Dim CrLf As String
Dim dataFile As String

Dim Adding As Integer
Dim thePriority As Integer

Sub Data1_Reposition ()
Dim i As Integer

    If (Not Data1.Recordset.BOF) And (Not Data1.Recordset.EOF) Then
	For i% = 0 To 2
	    optPriority(i%).Value = False
	Next i%
	If Adding% Then
	    optPriority(0).Value = True
	    chkDone.Value = False
	    mskDueDate = Format$(Now, "mm-dd-yy")
	Else
	    If Not (IsNull(Data1.Recordset("Priority"))) Then
		optPriority(Data1.Recordset("Priority")).Value = True
	    End If
	    If Not (IsNull(Data1.Recordset("Date"))) Then
		mskDueDate = Format$(Data1.Recordset("Date"), "mm-dd-yy")
	    End If
	End If
    End If
End Sub

Sub Form_KeyPress (KeyAscii As Integer)
Dim msg As String
Dim answer As Integer

    Select Case KeyAscii%
	Case 13 ' Enter key
	    Select Case ActiveControl.Tag
		Case "Done"
		    optPriority(0).SetFocus
		Case "Priority"
		    mskDueDate.SetFocus
		Case "DueDate"
		    txtDescription.SetFocus
		Case "Description"
		    mskDueDate.SetFocus
		    If Adding% Then
			Data1.Recordset.AddNew
		    ' This next section of code looks redundent.
		    ' It isn't, however, because if EOF isn't True,
		    ' it might be if we are on the last record.
		    ' This way, if we were on the last valid record,
		    ' we won't have created an EOF situation by
		    ' moving to past the end of the file.
		    ElseIf Not Data1.Recordset.EOF Then
			Data1.Recordset.MoveNext
		    End If
		    If Data1.Recordset.EOF Then
			Data1.Recordset.MoveLast
			msg$ = "This is the last record in the list." + CrLf$
			msg$ = msg$ + "Do you want to add a new record?"
			answer% = MsgBox(msg$, MB_ICONQUESTION + MB_YESNO, "Add Record?")
			If answer% = IDYES Then
			    Adding% = True
			    Data1.Recordset.AddNew
			End If
		    End If
	    End Select
	    KeyAscii% = 0
	Case 27 ' Escape
	    If Adding% Then
		Adding% = False
		Data1.Recordset.MoveLast
	    End If
	    KeyAscii% = 0
    End Select
End Sub

Sub Form_Load ()
    CrLf$ = Chr$(10) + Chr$(13)

    dataFile$ = FullName$((App.Path), "TODO.MDB")
    Data1.DatabaseName = dataFile$
    Data1.RecordSource = "ToDoList"
    Data1.Refresh
    If (Data1.Recordset.BOF) And (Data1.Recordset.EOF) Then
	Data1.Recordset.AddNew
    End If
End Sub

Sub mnuFileExit_Click ()
    Unload Me
End Sub

Sub mnuFileSortDueDate_Click ()
    Data1.RecordSource = "Select * From ToDoList Order by [Date]"
    Data1.Refresh
End Sub

Sub mnuFileSortNone_Click ()
    Data1.RecordSource = "ToDoList"
    Data1.Refresh
End Sub

Sub mnuFileSortPriority_Click ()
    Data1.RecordSource = "Select * From ToDoList Order by [Priority]"
    Data1.Refresh
End Sub

Sub mnuFileSortStatus_Click ()
    Data1.RecordSource = "Select * From ToDoList Order by [Done]"
    Data1.Refresh
End Sub

Sub mnuRecordAdd_Click ()
    Adding% = True
    Data1.Recordset.AddNew
End Sub

Sub mnuRecordDelete_Click ()
    If (Not Data1.Recordset.BOF) And (Not Data1.Recordset.EOF) Then
	Data1.Recordset.Delete
	Data1.Recordset.MoveNext
    Else
	Data1.Recordset.MoveLast
    End If
End Sub

Sub mnuRecordSave_Click ()
Dim changed As Integer

    If (IsNull(Data1.Recordset("Priority"))) Or (thePriority% <> Data1.Recordset("Priority")) Then
	changed% = True
    End If
    If (IsNull(Data1.Recordset("Date"))) Or (DateValue(mskDueDate.Text) <> Data1.Recordset("Date")) Then
	changed% = True
    End If
    If txtDescription.DataChanged Or chkDone.DataChanged Then
	changed% = True
    End If
    If changed% Then
	If Data1.EditMode = DATA_EDITNONE Then
	    Data1.Recordset.Edit
	End If
	Data1.Recordset("Priority") = thePriority%
	Data1.Recordset("Date") = DateValue(mskDueDate.Text)
	Data1.Recordset.Update
    End If
    If Adding% Then
	Data1.Recordset.AddNew
    Else
	If Data1.Recordset.EOF Then
	    Data1.Recordset.MoveLast
	End If
    End If
End Sub

Sub mnuSearchFirst_Click ()
    dlgSearch.Show MODAL
    Data1.Recordset.FindFirst Query
    If Data1.Recordset.NoMatch Then
	MsgBox "No matching records were found.", 0, "Data Control Demo"
    End If
End Sub

Sub mnuSearchLast_Click ()
    dlgSearch.Show MODAL
    Data1.Recordset.FindLast Query
    If Data1.Recordset.NoMatch Then
	MsgBox "No matching records were found.", 0, "Data Control Demo"
    End If
End Sub

Sub mnuSearchNext_Click ()
    dlgSearch.Show MODAL
    Data1.Recordset.FindNext Query
    If Data1.Recordset.NoMatch Then
	MsgBox "No matching records were found.", 0, "Data Control Demo"
    End If
End Sub

Sub mnuSearchPrevious_Click ()
    dlgSearch.Show MODAL
    Data1.Recordset.FindPrevious Query
    If Data1.Recordset.NoMatch Then
	MsgBox "No matching records were found.", 0, "Data Control Demo"
    End If
End Sub

Sub mskDueDate_GotFocus ()
    mskDueDate.SelStart = 0
    mskDueDate.SelLength = Len(mskDueDate.Text)
End Sub

Sub optPriority_Click (Index As Integer)
    thePriority = Index
End Sub

