// point2d.cpp
//	File to test the functionality of the Point2D class.

#include <iostream.h>

class Point2D {
protected:
    int x, y;
public:
    Point2D() { x = y = 0; }
    Point2D(int X, int Y) { x = X; y = Y; }
    virtual Point2D& operator-() {
	x = -x;  y = -y;
	return *this;
    }
    virtual Point2D operator+(const Point2D& a) {
	return Point2D(x + a.x, y + a.y);
    }
    friend ostream& operator<<(ostream& s, const Point2D& p) {
	s << '(' << p.x << ", " << p.y << ')';
	return s;
    }
};

#if 0
class Point2D {
    int x, y;
public:
    Point2D() { x = y = 0; }
    Point2D(int X, int Y) { x = X; y = Y; }
    friend Point2D& operator-(Point2D& a) {
	a.x = -a.x;  a.y = -a.y;
	return a;
    }
    friend Point2D operator+(const Point2D& a, const Point2D& b) {
	return Point2D(a.x + b.x, a.y + b.y);
    }
    friend ostream& operator<<(ostream& s, const Point2D& p) {
	s << '(' << p.x << ", " << p.y << ')';
	return s;
    }
};
#endif

int
main()
{
    Point2D a(1, 5);
    Point2D b(6, 2);
    cout << a + -b << '\n';
    return 0;
}
