Program FrameTest;

  Uses
    WinCRT,
    FrameLib;

  Var
    PcData,
    FrameData: Array [1..74] of Char;
    PackValue: Array [1..6] of Char;
    IValue: Integer;
    RValue: Real;

Begin
  PcData := 
    'This is a test of FrameLib,'+
    ' a unit for performing frame-to-PC conversions.';
  WriteLn (PcData);
  AsciiToEbcdic (PcData, FrameData, SizeOf (FrameData));
  WriteLn (FrameData);
  EbcdicToAscii (FrameData, PcData, SizeOf (PcData));
  WriteLn (PcData);

  IValue := 726;
  IntToPacked (IValue, PackValue, SizeOf (PackValue));
  WriteLn ('PackedToInt 1 = ', 
            PackedToInt (PackValue, SizeOf (PackValue)));
  IValue := -65;
  IntToPacked (IValue, PackValue, SizeOf (PackValue));
  WriteLn ('PackedToInt 2 = ', 
            PackedToInt (PackValue, SizeOf (PackValue)));

  WriteLn ('PackedToReal 1 = ', 
            PackedToReal (PackValue, SizeOf (PackValue), 2):6:2);
  RValue := 22.4;
  RealToPacked (RValue, PackValue, SizeOf (PackValue), 1);
  WriteLn ('PackedToReal 2 = ', 
            PackedToReal (PackValue, SizeOf (PackValue), 1):6:2);
End.