/**********************************************************
**  MEMAVAIL.C- A detachable process that will
**   monitor the available system memory and log it every
**   5 seconds for as many minutes as you specify on
**   the command line. For example typing:
**
**            MEMAVAIL 10
**
**   will log memory usage for 10 minutes. The default
**   duration is 5 minutes if no command line arg is
**   entered.
**
**   Once MEMAVAIL has been detached, you can use
**   KILLPROC.EXE to terminate it. Otherwise, it will run
**   for the specified number of minutes, after which it
**   will shut itself down.
**
**   Compiled using JPI TopSpeed C++ for OS/2. Be sure
**    to use the multithreaded library.
**
**   George Shepherd - June 23, 1993
*/
#define INCL_DOS
#define INCL_SUB
#include <os2kernl.h>
#include <stdio.h>
#include <string.h>
#include <conio.h>
#include <stdlib.h>

DATETIME datetimeStart;
static char szFileName[] = "memavail.txt";
FILE *fileMemAvail = NULL;

VOID PASCAL FAR exitProc(USHORT u) {
   /***************************************************
   ** This exit procedure is called whenever the
   **  entire process terminates. It performs cleanup-
   **    1) Gets the end of process date and time
   **    2) Write end of process data and time to
   **        log file
   **    3) Close the log file
   */
   DATETIME datetimeEnd;
   char szTimeOnInfo[80];

   DosGetDateTime(&datetimeEnd);

   if(fileMemAvail) {
      /* Write the start and end time to the file... */
      sprintf(szTimeOnInfo,
              "Session started: %u/%u/%u at %u:%02u \
and ended %u/%u/%u at %u:%02u\n",
              datetimeStart.month, datetimeStart.day,
              datetimeStart.year, datetimeStart.hours,
              datetimeStart.minutes, datetimeEnd.month,
              datetimeEnd.day, datetimeEnd.year,
              datetimeEnd.hours, datetimeEnd.minutes);
      fputs(szTimeOnInfo, fileMemAvail);

      fclose(fileMemAvail);
   }

   /* Continue with the exiting... */
   DosExitList(EXLST_EXIT, 0L);
}

main(int argc, char **argv) {

   char szMemAvail[80]; // string to hold memavail info
   long lElapsedMilliseconds = 0L;
   unsigned const uInterval = 5000; // 5 seconds
   long lDefMilliseconds = 300000L; // 1000*60*5 (5 min)

   /* Get the logging duration in minutes from  */
   /*  the command line (if available... )      */
   if(argc == 2) {
      char  szMinutes[5]; // holds minutes from cmd line
      USHORT uMinutes;

      strncpy(szMinutes, argv[1], sizeof(szMinutes));
      szMinutes[sizeof(szMinutes)] = '\0';
      uMinutes = atoi(szMinutes);
      lDefMilliseconds = (long)1000*60*uMinutes;
   }

   /* Get the session start date and time... */
   DosGetDateTime(&datetimeStart);

   /* Set up the exit procedure so that it will record   */
   /*  the session date and time and close the file      */
   /*  upon termination.                                 */
   DosExitList(EXLST_ADD, exitProc);

   /* Open the log file...    */
   fileMemAvail = fopen(szFileName, "w");

   if(fileMemAvail) {
      fputs("Memory Usage Log\n\n", fileMemAvail);

      /* Start the memory logging loop... */
      while( lElapsedMilliseconds < lDefMilliseconds) {
         ULONG uMemAvail;
         DATETIME datetimeCurrent;

         DosMemAvail(&uMemAvail); /* get memory snapshot */
         DosGetDateTime(&datetimeCurrent);
         sprintf(szMemAvail,
         "Available memory at %u:%02u:%02u : %lu bytes\n",
                 datetimeCurrent.hours,
                 datetimeCurrent.minutes,
                 datetimeCurrent.seconds,
                 uMemAvail);
         fputs(szMemAvail, fileMemAvail);
         DosSleep(uInterval); /* sleep for a while... */
         lElapsedMilliseconds += uInterval;
      }
   } else {
      /* Pop up message- couldn't open the file... */
      USHORT uWaitFlag = 1; // wait for a pop up screen

      VioPopUp( &uWaitFlag, 0 ); // 0 is the screen handle
      printf("Couldn't open file 'memavail.txt'.\n");
      printf("Ending process.\n");
      printf("Press any key to continue...\n");
      while(!kbhit());
      VioEndPopUp(0);
   }
}
