// exec.cpp -- Run DOS and Windows programs

#include <owl.h>       // Include ObjectWindows header
#include "exec.rch"    // Include resource declarations

// The application class
class TExecApp: public TApplication {
public:
  TExecApp(LPSTR AName, HINSTANCE AnInstance,
    HINSTANCE APrevInstance, LPSTR ACmdLine, int ACmdShow)
    : TApplication(AName, AnInstance, APrevInstance,
      ACmdLine, ACmdShow) {};
  virtual void InitMainWindow();
};

// Main window class
class TExecWin: public TWindow {
public:
  TExecWin(PTWindowsObject AParent, LPSTR ATitle);
  void WinExecErr(WORD w);
  virtual void CMFileExit(RTMessage)
    = [CM_FIRST + CM_FILE_EXIT];
  virtual void CMRunNotepad(RTMessage)
    = [CM_FIRST + CM_RUN_NOTEPAD];
  virtual void CMRunGrep(RTMessage)
    = [CM_FIRST + CM_RUN_GREP];
};

// Initialize main window
void TExecApp::InitMainWindow()
{
  MainWindow = new TExecWin(NULL, "WinExec Demonstration");
}

// Construct main window object
TExecWin::TExecWin(PTWindowsObject AParent, LPSTR ATitle)
  : TWindow(AParent, ATitle)
{
  AssignMenu(ID_MENU);
}

// Display message for a WinExec error
void TExecWin::WinExecErr(WORD w)
{
  if (w < 32) {
    char szMsg[80];  // Error message string
    wvsprintf(szMsg, "WinExec failed; error code = %d", &w);
    MessageBox(HWindow, szMsg, "Error", MB_ICONSTOP);
  }
}

// Respond to File|Exit command: exit program
void TExecWin::CMFileExit(RTMessage)
{
  CloseWindow();
}

// Respond to Run|Notepad command
// Requires README.TXT file in current directory
void TExecWin::CMRunNotepad(RTMessage)
{
  WORD wReturn = WinExec(    // Call Windows WinExec()
    "notepad readme.txt",    // Command to execute
    SW_SHOW);                // Window-show command
  WinExecErr(wReturn);       // Check for errors
}

// Respond to Run|Grep command
// Requires DOS GREP.COM to be on the PATH
void TExecWin::CMRunGrep(RTMessage)
{
  WORD wReturn = WinExec(
    "c:\command.com /C grep.com class *.cpp >result.txt",
    SW_NORMAL);
  WinExecErr(wReturn);
}

int PASCAL WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance,
  LPSTR lpszCmdLine, int nCmdShow)
{
  TExecApp ExecApp("ExecApp", hInstance, hPrevInstance,
    lpszCmdLine, nCmdShow);
  ExecApp.Run();
  return ExecApp.Status;
}
