// blank.cpp -- Display black, blank, borderless window

#include <owl.h>

class TBlankApp: public TApplication {
public:
  TBlankApp(LPSTR AName, HINSTANCE AnInstance,
    HINSTANCE APrevInstance, LPSTR ACmdLine, int ACmdShow)
    : TApplication(AName, AnInstance, APrevInstance,
      ACmdLine, ACmdShow) {};
  virtual void InitMainWindow();
};

class TBlankWin: public TWindow {
public:
  TBlankWin(PTWindowsObject AParent, LPSTR ATitle);
  virtual void GetWindowClass(WNDCLASS &AWndClass);
  virtual LPSTR GetClassName()
    { return "TBlankWin"; }
  virtual void WMLButtonDown(RTMessage)
    = [WM_FIRST + WM_LBUTTONDOWN];
  virtual void WMKeyDown(RTMessage)
    = [WM_FIRST + WM_KEYDOWN];
};

// Initialize TBlankApp's main window
void TBlankApp::InitMainWindow()
{
  MainWindow = new TBlankWin(NULL, "Blank Window");
}

// Construct main window object
TBlankWin::TBlankWin(PTWindowsObject AParent, LPSTR ATitle)
  : TWindow(AParent, ATitle)
{
  Attr.X = 0;
  Attr.Y = 0;
  Attr.W = GetSystemMetrics(SM_CXSCREEN);
  Attr.H = GetSystemMetrics(SM_CYSCREEN);
  Attr.Style = WS_POPUP | WS_MAXIMIZE;
}

// Modify window class to paint background black
void TBlankWin::GetWindowClass(WNDCLASS &AWndClass)
{
  TWindow::GetWindowClass(AWndClass);
  AWndClass.hbrBackground = (HBRUSH)GetStockObject(BLACK_BRUSH);
}

// Exit program on click of left mouse button
void TBlankWin::WMLButtonDown(RTMessage)
{
  CloseWindow();
}

// Exit program on any keypress
void TBlankWin::WMKeyDown(RTMessage)
{
  CloseWindow();
}

int PASCAL WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance,
  LPSTR lpszCmdLine, int nCmdShow)
{
  TBlankApp BlankApp("BlankApp", hInstance, hPrevInstance,
    lpszCmdLine, nCmdShow);
  BlankApp.Run();
  return BlankApp.Status;
}
