/* FD_VERIFY_SECTORS - Verify Diskette Sectors                          */

#include <stdio.h>
#include "diskette.h"

static struct fd_afld _far af_table[15] =       /* 1.2M diskette        */
{
  { 0, 0, 1, 2 }, { 0, 0, 2, 2 }, { 0, 0, 3, 2 },
  { 0, 0, 4, 2 }, { 0, 0, 5, 2 }, { 0, 0, 6, 2 },
  { 0, 0, 7, 2 }, { 0, 0, 8, 2 }, { 0, 0, 9, 2 },
  { 0, 0, 10, 2 }, { 0, 0, 11, 2 }, { 0, 0, 12, 2 },
  { 0, 0, 13, 2 }, { 0, 0, 14, 2 }, { 0, 0, 15, 2 }
};

int main()
{
  struct fd_diskette disk;

  puts("\nCTEST_08 - Verify Diskette Sectors\n");

  if (fd_open(&disk, 0) == TRUE)
  {
    if (fd_verify_sectors(&disk, 15, 0, 1, 0, af_table) == TRUE)
      printf("Sectors verified\n");
    else     
      printf("Sectors failed verification\n");

    fd_close(&disk);
  }
  else
    printf("Drive A could not be opened\n");

  return (0);
}

