/* FD_INSTALL_TABLE - Install Custom Diskette Parameters Table          */

#include <stdio.h>
#include "diskette.h"

static struct fd_dprm _far new_dpt =    /* 1.2M diskette                */
{
  0xdf, 0x02, 0x25, 0x02, 0x0f, 0x1b, 0xff, 0x54, 0xf6, 0x0f, 0x08
};

int main()
{
  struct fd_diskette disk;

  puts("\nCTEST_02 - Install Custom Diskette Parameters Table\n");

  if (fd_open(&disk, 0) == TRUE)
  {
    if (fd_install_table(&disk, &new_dpt) == TRUE)
    {
      printf("New Diskette Parameters table installed\n");

      fd_remove_table(&disk);

      printf("Previous Diskette Parameters table restored\n");
    }
    else
      printf("Diskette Parameters table not installed\n");

    fd_close(&disk);
  }
  else
    printf("Drive A could not be opened\n");

  return (0);
}

