; Copyright (c) 1992 by Robert D. Bowes

.Model  medium, windows pascal
.286P

.Code

; Verify that the specified pointer is valid. First, the selector is
; validated, then the offset is validated relative to the selector.
; If the pointer is valid, TRUE (1) is returned; else FALSE (0) is
; returned. The C language prototype is as follows:

;       BOOL FAR PASCAL is_pointer_valid(LPVOID pointer)

Public  is_pointer_valid

ofs_sel equ     8       ; offset of selector for pointer param
ofs_ofs equ     6       ; offset of offset portion of pointer param

is_pointer_valid        Proc

        ; a proper stack frame for Windows should be automatically
        ; established by TASM (see the .Model directive)

        xor     ax,ax           ; assume failure

        mov     dx,[bp+ofs_sel] ; validate the specified selector
        lar     bx,dx
        jnz     bail

        lsl     bx,dx           ; get the selector segment limit or
        jnz     bail            ; an error if the selector can't be
                                ; read
        cmp     bx,[bp+ofs_ofs] ; make sure the offset is less than
        jbe     bail            ; the limit

        verw    dx              ; make sure selector is writable
        jnz     bail            ; (i.e. data)

        mov     ax,1            ; pointer must be valid to get here

bail:

        ; proper stack cleanup should be done automatically by TASM
        ; (see the .Model directive)

        ret

is_pointer_valid        Endp

End
