PROGRAM TestDrv;

USES GetDrive;

TYPE
  IDType = 'A'..'Z';
  DriveSetType = SET OF IDType;
VAR
  DriveSet : DriveSetType;
  Ch : Char;
  DummySet : LongInt ABSOLUTE DriveSet;

BEGIN
  DummySet := GetValidDrives;
  Write('      Valid : ');
  FOR Ch := 'A' TO 'U' DO
    BEGIN
      IF Ch IN DriveSet THEN Write(' ', Ch, ' ')
      ELSE Write('   ');
    END;
  WriteLn;
  DummySet := GetRemovableDrives;
  Write(' Removable : ');
  FOR Ch := 'A' TO 'U' DO
    BEGIN
      IF Ch IN DriveSet THEN Write(' ', Ch, ' ')
      ELSE Write('   ');
    END;
  WriteLn;
  DummySet := GetSubstDrives;
  Write('Substituted : ');
  IF DriveSet = [] THEN Write('No substituted drives')
  ELSE FOR Ch := 'A' TO 'U' DO
    BEGIN
      IF Ch IN DriveSet THEN Write(' ', Ch, ' ')
      ELSE Write('   ');
    END;
  WriteLn;
  DummySet := GetNetworkDrives;
  Write('  Networked : ');
  IF DriveSet = [] THEN Write('No network drives')
  ELSE FOR Ch := 'A' TO 'U' DO
    BEGIN
      IF Ch IN DriveSet THEN Write(' ', Ch, ' ')
      ELSE Write('   ');
    END;
  WriteLn;
END.
